% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main-datautil.R
\name{new_x}
\alias{new_x}
\title{Create test input points for prediction}
\usage{
new_x(data, x_values, group_by = "id", x = "age", x_ns = NULL)
}
\arguments{
\item{data}{A data frame. Can also be an \linkS4class{lgpfit} or
\linkS4class{lgpmodel} object, in which case data is extracted from it.}

\item{x_values}{the values of \code{x} to set for each individual}

\item{group_by}{name of the grouping variable, must be a factor
in \code{data} (or use \code{group_by=NA} to create a dummy grouping
factor which has only one value)}

\item{x}{of the variable along which to extend,
must be a numeric in \code{data}}

\item{x_ns}{of a nonstationary variable derived from \code{x},
must be a numeric in \code{data}}
}
\value{
a data frame containing the following columns
\itemize{
 \item all factors in the original \code{data}
 \item \code{x}
 \item \code{x_ns} (unless it is NULL)
}
}
\description{
Replaces a continuous variable \code{x} in the data frame, and
possibly another continuous variable \code{x_ns} derived from it, with new
values, for each level of a grouping factor (usually id)
}
\seealso{
Other data frame handling functions: 
\code{\link{add_dis_age}()},
\code{\link{add_factor}()},
\code{\link{add_factor_crossing}()},
\code{\link{adjusted_c_hat}()},
\code{\link{split}()}
}
\concept{data frame handling functions}
