% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{refine_keywords}
\alias{refine_keywords}
\title{Refine keywords}
\usage{
refine_keywords(keywords, docs, prune = TRUE)
}
\arguments{
\item{keywords}{a list of keywords}

\item{docs}{a keyATM_docs object, generated by \code{keyATM_read()} function}

\item{prune}{logical, whether to prune keywords that do not appear in the documents}
}
\value{
a list of refined keywords
}
\description{
Refine keywords by (1) dropping keywords that do not appear in the documents and (2) dropping topics that does not have any occurence in the documents.
}
\examples{
\dontrun{
  library(quanteda)
  data(keyATM_data_bills)
  bills_keywords <- keyATM_data_bills$keywords
  bills_dfm <- keyATM_data_bills$doc_dfm  # quanteda dfm object
  keyATM_docs <- keyATM_read(bills_dfm)
  bills_keywords$Videogame <- c("metroid", "castlevania", "balatro")
  refine_keywords(bills_keywords, keyATM_docs)
}
}
