% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidths.r
\name{calculate.bandwidths.by.resolution}
\alias{calculate.bandwidths.by.resolution}
\title{Calculate temporal bandwidths by spatial resolution}
\usage{
calculate.bandwidths.by.resolution(
  dataset,
  dependent.variable = "dependent.variable",
  time = "year",
  weight = "weight",
  alpha = 0.05,
  margin = 0.1,
  measure.times,
  temporal.bandwidth.limits,
  temporal.bandwidth.n.levels = 200,
  minimum.spatial.resolution = 5,
  summary.plots = FALSE,
  kernel.function = gaussian.kernel
)
}
\arguments{
\item{dataset}{The dataset to be smoothed as a data.frame.}

\item{dependent.variable}{String name of the column in dataset with the dependent variable (defaults to "dependent.variable"); this column should be numeric or factor.}

\item{time}{String name of the column in dataset with the time variable (defaults to "year").}

\item{weight}{String name of column in the dataset with numeric weights (defaults to "weight").}

\item{alpha}{Numeric alpha for calculating error margins (defaults to 0.05).}

\item{margin}{Numeric desired error margin for calculating spatial bandwidths (defaults to 0.1).}

\item{measure.times}{A numeric vector of specific times at which to make estimates; if not given, will default to seq(from=min(time),to=max(time),length.out=5).}

\item{temporal.bandwidth.limits}{Numeric vector of length 2 specifying minimum and maximum temporal bandwidth to be tested (defaults to the range of time\emph{0.01 to the range of time}2).}

\item{temporal.bandwidth.n.levels}{Number of distinct levels of temporal bandwidth to be tested (defaults to 200).}

\item{minimum.spatial.resolution}{Numeric minimum spatial resolution.}

\item{summary.plots}{If TRUE, plots of smoothed sample density, the dependent variable, and variance are returned along with the plot of resolution by bandwidth.}

\item{kernel.function}{The kernel function, one of gaussian.kernel, gaussian.square.kernel, triangular.kernel, square.kernel, or a custom function (defaults to gaussian.kernel).}
}
\value{
A list containing a plot of spatial resolution by temporal bandwidth, along with other summary plots of the data if summary.plots==TRUE, and the calculated minimum temporal bandwidth.
}
\description{
This function calculates relationships between temporal bandwidth and possible spatial resolution for a given power and suggests minimum possible temporal bandwidth for a given resolution
}
