% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-core.R
\name{layer_reshape}
\alias{layer_reshape}
\title{Reshapes an output to a certain shape.}
\usage{
layer_reshape(
  object,
  target_shape,
  input_shape = NULL,
  batch_input_shape = NULL,
  batch_size = NULL,
  dtype = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{target_shape}{List of integers, does not include the samples dimension
(batch size).}

\item{input_shape}{Input shape (list of integers, does not include the
samples axis) which is required when using this layer as the first layer in
a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Reshapes an output to a certain shape.
}
\section{Input and Output Shapes}{


Input shape: Arbitrary, although all dimensions in the input shaped must be
fixed.

Output shape: \verb{(batch_size,) + target_shape}.
}

\seealso{
Other core layers: 
\code{\link{layer_activation}()},
\code{\link{layer_activity_regularization}()},
\code{\link{layer_attention}()},
\code{\link{layer_dense}()},
\code{\link{layer_dense_features}()},
\code{\link{layer_dropout}()},
\code{\link{layer_flatten}()},
\code{\link{layer_input}()},
\code{\link{layer_lambda}()},
\code{\link{layer_masking}()},
\code{\link{layer_permute}()},
\code{\link{layer_repeat_vector}()}
}
\concept{core layers}
