% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{reducedDimPlot}
\alias{reducedDimPlot}
\title{Scatter plot for dimensional reduction results}
\usage{
reducedDimPlot(
  TapestriExperiment,
  alt.exp = "alleleFrequency",
  dim.reduction,
  dim.x = 1,
  dim.y = 2,
  group.label = NULL
)
}
\arguments{
\item{TapestriExperiment}{\code{TapestriExperiment} object}

\item{alt.exp}{Character, \code{altExp} to use, \code{NULL} uses top-level/main experiment. Default "alleleFrequency".}

\item{dim.reduction}{Character, dimension reduction to plot, either "PCA" or "UMAP".}

\item{dim.x}{Numeric, index of dimensional reduction data to plot on X axis. Default 1.}

\item{dim.y}{Numeric, index of dimensional reduction data to plot on Y axis. Default 2.}

\item{group.label}{Character, \code{colData} column for grouping samples by color. Default \code{NULL}.}
}
\value{
ggplot2 object, scatter plot
}
\description{
Plots a scatter plot of the indicated dimensional reduction results.
}
\examples{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
tap.object <- runPCA(tap.object, alt.exp = "alleleFrequency")
reducedDimPlot(tap.object, dim.reduction = "pca")
}
\concept{dimensional reduction}
\concept{plots}
