% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliability.h.R
\name{reliability}
\alias{reliability}
\title{Reliability Analysis}
\usage{
reliability(data, vars, alphaScale = TRUE, omegaScale = FALSE,
  meanScale = FALSE, sdScale = FALSE, corPlot = FALSE,
  alphaItems = FALSE, omegaItems = FALSE, meanItems = FALSE,
  sdItems = FALSE, itemRestCor = FALSE, revItems = NULL)
}
\arguments{
\item{data}{the data as a data frame}

\item{vars}{a vector of strings naming the variables of interest in
\code{data}}

\item{alphaScale}{\code{TRUE} (default) or \code{FALSE}, provide Cronbach's
alpha}

\item{omegaScale}{\code{TRUE} or \code{FALSE} (default), provide McDonald's
omega}

\item{meanScale}{\code{TRUE} or \code{FALSE} (default), provide the mean}

\item{sdScale}{\code{TRUE} or \code{FALSE} (default), provide the standard
deviation}

\item{corPlot}{\code{TRUE} or \code{FALSE} (default), provide a correlation
plot}

\item{alphaItems}{\code{TRUE} or \code{FALSE} (default), provide what the
Cronbach's alpha would be if the item was dropped}

\item{omegaItems}{\code{TRUE} or \code{FALSE} (default), provide what the
McDonald's omega would be if the item was dropped}

\item{meanItems}{\code{TRUE} or \code{FALSE} (default), provide item means}

\item{sdItems}{\code{TRUE} or \code{FALSE} (default), provide item standard
deviations}

\item{itemRestCor}{\code{TRUE} or \code{FALSE} (default), provide item-rest
correlations}

\item{revItems}{a vector containing strings naming the varibales that are
reverse scaled}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$scale} \tab \tab \tab \tab \tab a table \cr
  \code{results$items} \tab \tab \tab \tab \tab a table \cr
  \code{results$corPlot} \tab \tab \tab \tab \tab an image \cr
  \code{results$meanScoreOV} \tab \tab \tab \tab \tab an output \cr
  \code{results$sumScoreOV} \tab \tab \tab \tab \tab an output \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$scale$asDF}

\code{as.data.frame(results$scale)}
}
\description{
Reliability Analysis
}
\examples{
data('iris')

reliability(iris, vars = c('Sepal.Length', 'Sepal.Width', 'Petal.Length', 'Petal.Width'),
            omegaScale = TRUE)

#
#  RELIABILITY ANALYSIS
#
#  Scale Reliability Statistics
#  -----------------------------------------
#             Cronbach's alpha    McDonald's omega
#  -----------------------------------------
#    scale           0.708           0.848
#  -----------------------------------------
#

}
