% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{clint_L3}
\alias{clint_L3}
\title{Clint Level-3 Example Data set}
\format{
A level-3 data.frame with 3 rows and 13 variables: \describe{
\item{\code{Compound.Name}}{Name of the test analyte/compound}
\item{\code{DTXSID}}{DSSTox Substance Identifier (CompTox Chemicals Dashboard - CCD)}
\item{\code{Lab.Compound.Name}}{Compound as described in the laboratory}
\item{\code{Calibration}}{Identifier for mass spectrometry calibration -- usually the date}
\item{\code{Clint}}{Intrinsic hepatic clearance}
\item{\code{Clint.pValue}}{p-value of estimated \code{Clint} value}
\item{\code{Fit}}{Test nominal concentrations}
\item{\code{AIC}}{Akaike Information Criterion of the linear regression fit}
\item{\code{AIC.Null}}{Akaike Information Criterion of the exponential decay assuming a constant rate of decay}
\item{\code{Clint.1}}{Intrinsic hepatic clearance at 1 uM}
\item{\code{Clint.10}}{Intrinsinc hepatic clearance at 10 uM}
\item{\code{AIC.Sat}}{Akaike Information Criterion of the exponential decay with a saturation probability}
\item{\code{Sat.pValue}}{p-value of exponential decay with a saturation probability}
}
}
\usage{
clint_L3
}
\description{
Mass Spectrometry measurements of intrinsic hepatic clearance (Clint) for cryopreserved 
pooled human hepatocytes. Chemicals were per- and poly-fluorinated alkyl substance
(PFAS) samples. The experiments were led by Dr.s Marci Smeltz and Barbara Wetmore 
\insertCite{smeltz2023plasma}{invitroTKstats}. This data set is a subset of 
experimental data containing samples for 3 test analytes/compounds.
}
\references{
\insertRef{shibata2002prediction}{invitroTKstats}

\insertRef{smeltz2023plasma}{invitroTKstats}
}
\keyword{datasets}
