% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{smeltz2023.red}
\alias{smeltz2023.red}
\alias{Smeltz2023.red}
\title{\insertCite{smeltz2023plasma;textual}{invitroTKdata} Rapid Equilibrium Dialysis Level-2 Data Set}
\format{
A level-2 data.frame with 3,955 rows and 25 variables: \describe{
\item{\code{Lab.Sample.Name}}{Sample description used in the laboratory}
\item{\code{Date}}{Date sample was acquired}
\item{\code{Compound.Name}}{Compound name}
\item{\code{DTXSID}}{DSSTox Substance Identifier (CompTox Chemicals Dashboard)}
\item{\code{Lab.Compound.Name}}{Compound as described in the laboratory}
\item{\code{Sample.Type}}{Type of RED sample}
\item{\code{Dilution.Factor}}{Number of times the sample was diluted}
\item{\code{Calibration}}{Identifier for mass spectrometry calibration -- usually the date}
\item{\code{Std.Conc}}{Concentration of analytic standard (for calibration curve) (uM)}
\item{\code{Test.Nominal.Conc}}{Intended concentration of chemical introduced into RED plate (uM)}
\item{\code{Percent.Physiologic.Plasma}}{Percent of physiological plasma concentration in RED plate (in percent)}
\item{\code{Time}}{Time of sample measurement (h)}
\item{\code{ISTD.Name}}{Name of compound used as internal standard (ISTD)}
\item{\code{ISTD.Conc}}{Concentration of ISTD (uM)}
\item{\code{ISTD.Area}}{Peak area of internal standard (pixels)}
\item{\code{Replicate}}{Identifier for replicate series of RED measurements}
\item{\code{Area}}{Peak area of analyte (target compound)}
\item{\code{Analysis.Method}}{General description of chemical analysis method}
\item{\code{Analysis.Instrument}}{Instrument(s) used for chemical analysis}
\item{\code{Analysis.Parameters}}{Parameters for identifying analyte peak (for example, retention time)}
\item{\code{Note}}{Any laboratory notes about sample}
\item{\code{Level0.File}}{Name of data file from laboratory that was used to compile level-0 data.frame}
\item{\code{Level0.Sheet}}{Name of "sheet" (for Excel workbooks) from which the laboratory data were read}
\item{\code{Response}}{Response factor (calculated from analyte and ISTD peaks)}
\item{\code{Verified}}{If "Y", then sample is included in the analysis. (Any other value causes the data to be ignored.)}
}
}
\usage{
smeltz2023.red
}
\description{
Mass Spectrometry measurements of plasma protein binding measured by
rapid equilibrium dialysis (RED) for per- and poly-fluorinated alkyl substance
(PFAS) samples from experiments led by Dr.s Marci Smeltz and Barbara Wetmore.
}
\references{
\insertRef{waters2008validation}{invitroTKdata}

\insertRef{smeltz2023plasma}{invitroTKdata}
}
\keyword{data}
