% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lininter.R
\name{linLIN}
\alias{linLIN}
\title{Linear regression interaction estimates}
\usage{
linLIN(
  var2values,
  model,
  data,
  var1,
  var2,
  ci = TRUE,
  conf = 0.95,
  ci.method = "delta",
  ci.boot.method = "perc",
  R = 100,
  parallel = "multicore",
  ...
)
}
\arguments{
\item{var2values}{numeric vector of var2 points to estimate}

\item{model}{model of class rms::Glm or stats::glm family gaussian. If data is NULL, the function expects to find the data in model$x}

\item{data}{data used in the model. If absent, it will attempt to recover the data from the model object. Only used for bootstrap CI}

\item{var1}{variable that increases by 1 unit from 0}

\item{var2}{variable to spline. var2values belong to var2}

\item{ci}{calculate 95\% CI?}

\item{conf}{confidence level. Default 0.95}

\item{ci.method}{confidence interval method. "delta" performs delta method. "bootstrap" performs bootstrapped CI (slower)}

\item{ci.boot.method}{one of the available bootstrap CI methods from \code{\link[boot]{boot.ci}}. Default percentile}

\item{R}{number of bootstrap samples if ci.method = "bootstrap". Default 100}

\item{parallel}{can take values "no", "multicore", "snow" if ci.method = "bootstrap". Default multicore}

\item{...}{other parameters for boot}
}
\value{
if ci = FALSE, a vector of estimate of length(var2values),
if ci = TRUE a dataframe with 5 columns, initial values, linear estimates, lower CI, upper CI and SE
}
\description{
Generate linear estimates for a 1 unit increase in a variable at
specified points of another interacting variable in a linear interaction model
}
\examples{
library(rms)
library(mlbench)
data(PimaIndiansDiabetes)
# Recode diabetes as 0/1
PimaIndiansDiabetes$diabetes <- ifelse(PimaIndiansDiabetes$diabetes=="pos" , 1 , 0)
myformula <- glucose ~ mass + diabetes * age
model <- glm(myformula , data = PimaIndiansDiabetes ,family=gaussian)
# Show the effect on glucose of being diabetic at age 20 to 80
linLIN( var2values = 20:80
       , model = model , data = PimaIndiansDiabetes , var1 ="diabetes", var2="age"
       , ci=TRUE , conf = 0.95 , ci.method = "delta")
}
