% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startWorkflow.R
\name{startWorkflow}
\alias{startWorkflow}
\title{\code{startWorkflow}: function to commence the integrated species distribution model workflow.}
\usage{
startWorkflow(
  Countries,
  Species,
  Projection,
  Save = TRUE,
  Richness = FALSE,
  saveOptions = list(projectDirectory = NULL, projectName = NULL),
  Quiet = FALSE
)
}
\arguments{
\item{Countries}{A vector of country names to complete the analysis over. If missing, a boundary object (of class \code{Spatial} or \code{sf}) has to be added to the model using \code{.$addArea} before any analysis is completed.}

\item{Species}{A vector of Species names (scientific) to include in the analysis. Names should be given carefully since the names provided will be used to obtain \emph{GBIF} observations.}

\item{Projection}{The coordinate reference system used in the workflow.}

\item{Save}{Logical argument indicating if the model objects and outputs should be saved as .rds files. Defaults to \code{TRUE}. If \code{FALSE} then the output of the workflow will be a list of objects at each step of the workflow.}

\item{Richness}{Logical option to create maps for each species individually, or create a species richness model. Defaults to \code{FALSE}.}

\item{saveOptions}{A list containing two items: \code{projectDirectory} indicating where the objects should be saved (defaults to \code{NULL}), and \code{projectName} which indicates the name for the folder in the relevant directory. The latter argument is required, regardless of the value given to \code{Save}.}

\item{Quiet}{Logical argument indicating if the workflow should provide the user messages during the setup and estimation process. Defaults to \code{TRUE}.}
}
\value{
An R6 object of class \code{species_model}. This object contains a collection of slot functions to assist the user in customizing their workflow.
}
\description{
Function to initialize the reproducible workflow using integrated species distribution models. The arguments for this function are used to specify which species and countries are to be studied, as well as how the results of the model should be saved (either as an R object or saved to some directory). This function outputs an \code{R6} object with additional slot functions to help further customize the model specification. See \code{?species_model} for more details on these functions.
}
\examples{
##Start a workflow without saving objects

workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = "+proj=longlat +ellps=WGS84",
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))
}
