% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_series.R
\name{get_data_series_filter}
\alias{get_data_series_filter}
\title{Get data from series for a specific operation given a filter}
\usage{
get_data_series_filter(
  operation = NULL,
  filter = NULL,
  periodicity = NULL,
  nlast = 1,
  dateStart = NULL,
  dateEnd = NULL,
  det = 0,
  tip = NULL,
  lang = "ES",
  page = 1,
  validate = TRUE,
  verbose = FALSE,
  unnest = FALSE
)
}
\arguments{
\item{operation}{(string): Code of the operation. To obtain a list of
available operations see \code{\link[=get_metadata_operations]{get_metadata_operations()}}.}

\item{filter}{(list): list of variables and values.
\subsection{Filtering data from series}{

When we request data from series there is the possibility of filtering data
on the fly using metadata information about the variables and their values
that define the series. To get variables for a given operation see
\code{\link[=get_metadata_variables]{get_metadata_variables()}} and to get values for a specific variable see
\code{\link[=get_metadata_values]{get_metadata_values()}}. See also \code{\link[=get_metadata_series_varval]{get_metadata_series_varval()}} to get all the values at once.
\subsection{Filter format}{

The format is \code{list(id_variable1 = id_value1, id_variable2 = id_value2)}.
Besides:
\itemize{
\item A variable can take more than one value: \code{list(id_variable1 = c(id_value11, id_value12), id_variable2 = id_value2)}.
\item A variable can take a empty character "" to get all its possible values: \code{list(id_variable1 = id_value1, id_variable2 = "")}.
}
}

\subsection{Using shortcuts}{

Additionally, shortcuts can be used to filter. They simplify the filtering
approach by using standardized names for variable IDs and therefore simplify
their use. The format is:
\code{list(shortcut_variable1 = name1, shortcut_variable2 = name2)}. Besides,
the \emph{values} wrapper can also be used: \verb{list(values = c(name1, name2)}.
To see a list of all available shortcuts, see \code{\link[=get_filter_shortcuts]{get_filter_shortcuts()}} function.
Let’s also remark that for better performance is recommended to use numeric codes.
}

}}

\item{periodicity}{(int): id of the periodicity of the series. Common periodicities:
1 (monthly), 3 (quarterly), 6 (bi-annual), 12 (annual). To obtain a list
of periodicities see \code{\link[=get_metadata_periodicity]{get_metadata_periodicity()}}.}

\item{nlast}{(int): number of periods to retrieve. By default is set to 1 period.}

\item{dateStart}{(string): the initial date of the requested data. The required
format is yyyy/mm/dd. Additionally, dateStart can be a vector of dates, where
each date represents the start date of individual ranges where the end date should be found
at the same position in the dateEnd vector. If dateStart and dateEnd are equal,
the specified dates are retrieved. If no end date is entered,
all dates will be queried, from the corresponding start date to the last available period.}

\item{dateEnd}{(string): the end date of the requested data. The required
format is yyyy/mm/dd. Additionally, dateEnd can be a vector of dates, where
each date represents the end date of individual ranges where the initial date should be found
at the same position in the dateStart vector. The length of the dateEnd vector
must be less than or equal to the length of the dateStart vector.}

\item{det}{(int): level of detail. Valid values: 0, 1 or 2.}

\item{tip}{(string): set to 'A' for friendly output (e.g. readable dates),
set to 'M' to include metadata or set to 'AM' for both.}

\item{lang}{(string): language of the retrieved data. Set to 'ES' for Spanish or set to 'EN' for English.}

\item{page}{(int): page number. The retrieved result of the query is paginated. Default value is set to 1.}

\item{validate}{(logical): validate the input parameters. A FALSE value means fewer API calls.
Therefore, it is recommended to set it to FALSE when there is no doubt about the validity of the input parameters, including the filter.}

\item{verbose}{(logical): print additional information, including the URL to call the API service.}

\item{unnest}{(logical): obtain a single data frame of data}
}
\value{
Data frame with data of series according to the operation and filter specified in the function
}
\description{
Get data from series for a specific operation given a filter
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get last five periods and filter data of time series from "IPC" operation
filter <- list("115"= "28", "3" = "84", "762" = "304092")
df <- get_data_series_filter(operation = "IPC", periodicity = 1,
nlast = 5, unnest = TRUE, validate = FALSE, filter = filter)
head(df)
\dontshow{\}) # examplesIf}
}
