% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-obj.R
\name{saveOBJ}
\alias{saveOBJ}
\alias{saveOBJ,trigrid-method}
\alias{saveOBJ,hexagrid-method}
\title{Export trigrid class object as Wavefront .obj file}
\usage{
saveOBJ(x, ...)

\S4method{saveOBJ}{trigrid}(x, file, scale = TRUE)

\S4method{saveOBJ}{hexagrid}(x, file, scale = TRUE)
}
\arguments{
\item{x}{A \code{trigrid} class object.}

\item{...}{Arguments of class-specific methods.}

\item{file}{A \code{character} path to a file to write.}

\item{scale}{A \code{logical} Should the grid vertices be scaled to unit diameter? Otherwise the values in kilometers will be exported.}
}
\value{
The function has no return value.
}
\description{
The function will take the given \code{trigrid} class object and write it's vertex, edge and face information as a .obj file
}
\details{
Note that \code{hexagrid} class objects are exported in their triangulated form (subfaces). The order of faces for \code{hexagrid}s is not the natural (UI) order but the internal order of subfaces.
}
\examples{
gr <- hexagrid(spacing=4)
# example written into temporary directroy
td <- tempdir()
td
# actual writing
saveOBJ(gr, file=file.path(td, "hexagrid.obj"))

}
