% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/totalLoglik.R
\name{totalLoglik}
\alias{totalLoglik}
\title{Total log-likelihood for observed data}
\usage{
totalLoglik(data, ids = NULL, k1, a, err = 0, prepped = FALSE)
}
\arguments{
\item{data}{Data frame with required columns \code{chrom}, \code{cm}, \code{a1} and \code{freq1}.}

\item{ids}{Genotype columns (ignored unless \code{prep = TRUE}).}

\item{k1, a}{HMM parameters.}

\item{err}{Error rate; a single number in \verb{[0,1]} (default: 0).}

\item{prepped}{A logical indicating if the input data has been internally
processed. Can be ignored by most users.}
}
\value{
A number: The total log-likelihood of the data under the HMM model.
}
\description{
This function computes the total log-likelihood of the observed data, under
the hidden Markov model. It is mainly for internal use, especially
\code{\link[=fitHMM]{fitHMM()}}.
}
\examples{
totalLoglik(cousinsDemo, k1 = 0.2, a = 5)

}
