% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gate.R
\name{flow_gate}
\alias{flow_gate}
\title{Discharge At Underflow Gate}
\usage{
flow_gate(a, h0, B, alpha, h2 = NULL, ret = "Q")
}
\arguments{
\item{a}{Gate opening height [m].}

\item{h0}{Upstream water depth [m].}

\item{B}{Gate width [m].}

\item{alpha}{Gate angle from horizontal [degrees].}

\item{h2}{Optional. Downstream water depth [m]. Default is NULL (free flow).}

\item{ret}{Specifies the return value. "Q" for discharge only or "all" for
all intermediate results.}
}
\value{
A list containing the following hydraulic variables:
\describe{
  \item{Q}{Flow [m3/s].}
  \item{psi}{Contraction coefficient [-].}
  \item{mu}{Discharge coefficient [-].}
  \item{v}{Flow velocity [m/s].}
  \item{chi}{Coefficient for submerged flow [-].}
}
}
\description{
Calculates the discharge through a gate under free or submerged
  conditions.
}
\examples{
flow_gate(a = 0.5, h0 = 1.0, B = 2.0, alpha = 90)
flow_gate(a = 0.5, h0 = 1.0, B = 2.0, alpha = 90, h2 = 0.8)
flow_gate(a = 0.5, h0 = 1.0, B = 2.0, alpha = 90, h2 = 0.8, ret = "all")
}
