% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broad-sense.R
\name{H2}
\alias{H2}
\title{Calculate heritability from mixed model object}
\usage{
H2(model, target, method = c("Cullis", "Oakey", "Delta", "Piepho", "Standard"), options)
}
\arguments{
\item{model}{Model object of class \code{lmerMod/merMod} or \code{asreml}}

\item{target}{The name of the random effect for which heritability is to be calculated.}

\item{method}{Character vector of name of method to calculate heritability. See details.}

\item{options}{NULL by default, for internal checking of model object before calculations}
}
\value{
A named numeric vector, length matching number of methods supplied
}
\description{
A case-specific wrapper for calculating heritability.
\itemize{
\item The upper case prefix \code{H2_} refers to the wrapper or subfunctions e.g. \code{\link[=H2_Delta]{H2_Delta()}} for calculating broad sense heritability
}
}
\details{
The following methods are currently implemented for broad-sense heritability \code{H2(method = "XX")}:
\itemize{
\item \code{"Cullis"}: \deqn{H^2_{Cullis} = 1 - \frac{PEV^{BLUP}_{\overline\Delta ij}}{2\sigma^2_g}}
\item \code{"Oakey"}: \deqn{H^2_{Oakey} = \frac{\sum_{i = n_z+1}^{n_g} \lambda_i}{\sum_{n_g}^{\lambda_i\neq 0}}}
\item \code{"Delta"}: \deqn{H^2_{\Delta ..} = 1 - \frac{PEV^{BLUP}_{\overline\Delta ..}}{2\sigma^2_g}}
\item \code{"Piepho"}: \deqn{H^2_{Piepho} = \frac{\sigma^2_g}{\sigma^2_g + \overline{PEV_{BLUE_g}} / 2}}
\item \code{"Standard"}: \deqn{H^2_{Standard} = \frac{\sigma^2_g}{\sigma^2_g + \frac{1}{n_g}\sum_{n_g}^{i=1} \sigma^2_p / n_{gi}}}
}

For further details of a specific method - take a look at help file for each subfunctions \code{?H2_Cullis}
}
\examples{
# lme4 model
lettuce_subset <- lettuce_phenotypes |> subset(loc == "L2")
lettuce_lme4 <- lme4::lmer(y ~ rep + (1 | gen), data = lettuce_subset)
H2(lettuce_lme4, target = "gen", method = c("Standard", "Delta"))

# asreml model (Requires license)
\dontrun{
lettuce_asreml <- asreml::asreml(fixed = y ~ rep,
                                 random = ~ gen,
                                 data = lettuce_subset,
                                 trace = FALSE
                                 )

H2(lettuce_asreml, target = "gen", method = c("Standard", "Delta"))
}
}
\references{
\itemize{
\item Cullis, B. R., Smith, A. B., & Coombes, N. E. (2006). On the design of early generation variety trials with correlated data. Journal of Agricultural, Biological, and Environmental Statistics, 11(4), 381–393. https://doi.org/10.1198/108571106X154443
\item Oakey, H., Verbyla, A., Pitchford, W., Cullis, B., & Kuchel, H. (2006). Joint modeling of additive and non-additive genetic line effects in single field trials. Theoretical and Applied Genetics, 113(5), 809–819. https://doi.org/10.1007/s00122-006-0333-z
\item Schmidt, P., Hartung, J., Rath, J., & Piepho, H.-P. (2019). Estimating Broad-Sense Heritability with Unbalanced Data from Agricultural Cultivar Trials. Crop Science, 59(2), 525–536. https://doi.org/10.2135/cropsci2018.06.0376
\item Piepho, H.-P., & Möhring, J. (2007). Computing Heritability and Selection Response From Unbalanced Plant Breeding Trials. Genetics, 177(3), 1881–1888. https://doi.org/10.1534/genetics.107.074229
\item Falconer, D. S., & Mackay, T. F. C. (1996). Introduction to quantitative genetics (4th ed.). Longman.
}
}
\seealso{
\code{\link[=H2_Cullis]{H2_Cullis()}}, \code{\link[=H2_Oakey]{H2_Oakey()}}, \code{\link[=H2_Delta]{H2_Delta()}}, \code{\link[=H2_Piepho]{H2_Piepho()}}, \code{\link[=H2_Standard]{H2_Standard()}}
}
