#' ATUS (American Time Use Survey) College/University Student Data
#' 
#' The 2024 data was downloaded from U.S. Bureau of Labor Statistics' website \url{https://www.bls.gov/tus/data/datafiles-2024.htm} and subset to include only respondents who are enrolled in college or university. This dataset is used only for educational purposes. Those conducting real research should download the data from its original source. BLS.gov cannot vouch for the data or analyses derived from these data after the data have been retrieved from BLS.gov.
#' 
#' @format A data frame with 312 rows and 5 variables. Each row represents a college student.
#' \describe{
#'   \item{employment}{full time or part time employment status of respondent}
#'   \item{age}{age}
#'   \item{enrollment}{are you enrolled as a full-time or part-time student?}
#'   \item{weekly_earnings}{weekly earnings at main job}
#'   \item{household_size}{number of people living in respondent's household}
#'   \item{time_alone}{total nonwork-related time respondent spent alone (in minutes)}
#'   \item{sleep_time}{time spent sleeping}
#'   \item{work_time}{time spent working at main job}
#'   \item{degree_class_time}{time spent taking class for degree, certification, or licensure}
#'   \item{shopping_time}{time spent shopping (store, telephone, internet)}
#'   \item{lunch_break_time}{time spent taking a lunch break}
#'   \item{sports_time}{time spent participating in sports, exercise, or recreation}
#'   \item{religious_time}{time spent attending or participating in religious services}
#' }
#' @source U.S. Bureau of Labor Statistics (2025). \url{https://nssdc.gsfc.nasa.gov/planetary/factsheet/index.html}.

"atus_college"