/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5EAmodule.h" 

#include "H5private.h"   
#include "H5Eprivate.h"  
#include "H5EApkg.h"     
#include "H5MMprivate.h" 

herr_t
H5EA_get_stats(const H5EA_t *ea, H5EA_stat_t *stats)
{
    FUNC_ENTER_NOAPI_NOERR

    
    assert(ea);
    assert(stats);

    
    H5MM_memcpy(stats, &ea->hdr->stats, sizeof(ea->hdr->stats));

    FUNC_LEAVE_NOAPI(SUCCEED)
} 
