% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_tbl_pivot_wider.R
\name{grouped_tbl_pivot_wider}
\alias{grouped_tbl_pivot_wider}
\alias{multinom_add_global_p_pivot_wider}
\alias{style_grouped_tbl}
\title{Helpers for grouped tables generated with \code{gtsummary}}
\usage{
grouped_tbl_pivot_wider(x)

multinom_add_global_p_pivot_wider(
  x,
  ...,
  p_value_header = "**Likelihood-ratio test**"
)

style_grouped_tbl(
  x,
  bold_groups = TRUE,
  uppercase_groups = TRUE,
  bold_labels = FALSE,
  italicize_labels = TRUE,
  indent_labels = 4L,
  bold_levels = FALSE,
  italicize_levels = FALSE,
  indent_levels = 8L
)
}
\arguments{
\item{x}{A grouped table generated with \code{\link[gtsummary:tbl_stack]{gtsummary::tbl_stack()}} or
\code{\link[gtsummary:tbl_regression]{gtsummary::tbl_regression()}}.}

\item{...}{Additional arguments passed to \code{\link[gtsummary:add_global_p]{gtsummary::add_global_p()}}.}

\item{p_value_header}{Header for the p-value column.}

\item{bold_groups}{Bold group group names?}

\item{uppercase_groups}{Convert group names to upper case?}

\item{bold_labels}{Bold variable labels?}

\item{italicize_labels}{Italicize variable labels?}

\item{indent_labels}{Number of spaces to indent variable labels.}

\item{bold_levels}{Bold levels?}

\item{italicize_levels}{Italicize levels?}

\item{indent_levels}{Number of spaces to indent levels.}
}
\value{
A \code{gtsummary} or a \code{gt} table.
}
\description{
A series of helpers for grouped tables generated by \code{\link[gtsummary:tbl_stack]{gtsummary::tbl_stack()}}
or \code{\link[gtsummary:tbl_regression]{gtsummary::tbl_regression()}} in case of multinomial models,
multi-components models or other grouped results.
\code{grouped_tbl_pivot_wider()} allows to display results in a a wide format,
with one set of columns per group. \code{multinom_add_global_p_pivot_wider()} is
a specific case for multinomial models, when displaying global p-values in a
wide format: it calls \code{\link[gtsummary:add_global_p]{gtsummary::add_global_p()}}, followed by
\code{grouped_tbl_pivot_wider()}, and then keep only the last column with p-values
(see examples). Finally, as grouped regression tables doesn't have exactly
the same structure as ungrouped tables, functions as
\code{\link[gtsummary:bold_italicize_labels_levels]{gtsummary::bold_labels()}} do not always work properly. If the grouped table
is kept in a long format, \code{style_grouped_tbl()} could be use to improve the
output by styling variable labels, levels and/or group names.
\strong{TO BE NOTED:} to style group names, \code{style_grouped_tbl()} convert the
table into a \code{gt} object with \code{\link[gtsummary:as_gt]{gtsummary::as_gt()}}. This function should
therefore be used last. If the table is intended to be exported to another
format, do not use \code{style_grouped_tbl()}.
}
\examples{
\dontshow{if (rlang::is_installed(c("gtsummary", "cardx", "nnet", "parameters"))) withAutoprint(\{ # examplesIf}
\donttest{
mod <- nnet::multinom(
  grade ~ stage + marker + age,
  data = gtsummary::trial,
  trace = FALSE
)
tbl <- mod |> gtsummary::tbl_regression(exponentiate = TRUE)
tbl
tbl |> grouped_tbl_pivot_wider()

tbl |> multinom_add_global_p_pivot_wider() |> gtsummary::bold_labels()
tbl |> style_grouped_tbl()

t1 <- gtsummary::trial |>
  gtsummary::tbl_summary(include = grade, by = trt)
t2 <- gtsummary::trial |>
  gtsummary::tbl_summary(include = stage, by = trt)

gtsummary::tbl_stack(list(t1, t2), group_header = c("Table 1", "Table 2")) |>
  style_grouped_tbl()
}
\dontshow{\}) # examplesIf}
}
\keyword{models}
