% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_downloads_page_data.R
\name{get_downloads_page_data}
\alias{get_downloads_page_data}
\title{Get Downloads Page Data}
\usage{
get_downloads_page_data(project_id, .return_raw = FALSE)
}
\arguments{
\item{project_id}{String. Options: "gtex", "adult-gtex", "egtex".}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
Retrieves all the files belonging to the given \code{project_id} for
display on the \verb{Downloads Page}

\href{https://gtexportal.org/api/v2/redoc#tag/Datasets-Endpoints/operation/get_downloads_page_data_api_v2_dataset_openAccessFilesMetadata_get}{GTEx Portal API documentation}
}
\details{
Note: The GTEx Portal API documentation states "GTEx currently has
one project available: gtex". However, \code{project_id} values "adult-gtex" and
"egtex" both return results, whereas "gtex" does not (see examples).
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# "adult-gtex" (default `project_id` value) and "egtex" both return results
get_downloads_page_data("adult-gtex")
egtex <- get_downloads_page_data("egtex")
egtex

# ..."gtex" does not
get_downloads_page_data("gtex")

# get details for whole blood methylation data, including download URL
purrr::pluck(
  egtex$children,
  1,
  "folders",
  "Methylation - EPIC Array",
  "children",
  "folders",
  "mQTLs",
  "children",
  "files",
  "WholeBlood.mQTLs.regular.txt.gz"
)
\dontshow{\}) # examplesIf}
}
\seealso{
Other Datasets Endpoints: 
\code{\link{get_annotation}()},
\code{\link{get_collapsed_gene_model_exon}()},
\code{\link{get_file_list}()},
\code{\link{get_full_get_collapsed_gene_model_exon}()},
\code{\link{get_functional_annotation}()},
\code{\link{get_linkage_disequilibrium_by_variant_data}()},
\code{\link{get_linkage_disequilibrium_data}()},
\code{\link{get_sample_datasets}()},
\code{\link{get_subject}()},
\code{\link{get_tissue_site_detail}()},
\code{\link{get_variant}()},
\code{\link{get_variant_by_location}()}
}
\concept{Datasets Endpoints}
