% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_tables.R
\name{info_tf_style}
\alias{info_tf_style}
\title{View a table with info on TRUE/FALSE formatting styles}
\usage{
info_tf_style(locale = NULL)
}
\arguments{
\item{locale}{\emph{Locale identifier}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional locale identifier that can be used for displaying formatted
TRUE/FALSE values according to the locale's rules. Examples include \code{"en"}
for English (United States) and \code{"fr"} for French (France). We can call
\code{\link[=info_locales]{info_locales()}} for a useful reference for all of the locales that are
supported. Note that only styles 1-3 (\code{"true-false"}, \code{"yes-no"}, and
\code{"up-down"}) support localization.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
\code{\link[=fmt_tf]{fmt_tf()}} lets us format logical values in a convenient manner using preset
styles. The table generated by \code{info_tf_style()} provides a quick reference
to all styles, with associated format names and example output values.
}
\section{Examples}{


Get a table of info on the different \code{TRUE}/\code{FALSE}-formatting styles (which
are used by supplying a number code or format name to \code{\link[=fmt_tf]{fmt_tf()}}).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{info_tf_style()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_info_tf_style_1.png" alt="This image of a table was generated from the first code example in the `info_tf_style()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

11-7
}

\section{Function Introduced}{

\emph{In Development}
}

\seealso{
Other information functions: 
\code{\link{info_currencies}()},
\code{\link{info_date_style}()},
\code{\link{info_flags}()},
\code{\link{info_google_fonts}()},
\code{\link{info_icons}()},
\code{\link{info_locales}()},
\code{\link{info_paletteer}()},
\code{\link{info_time_style}()},
\code{\link{info_unit_conversions}()}
}
\concept{information functions}
