% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{fmt_units}
\alias{fmt_units}
\title{Format measurement units}
\usage{
fmt_units(data, columns = everything(), rows = everything())
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{columns}{\emph{Columns to target}

\code{\link[=rows-columns]{<column-targeting expression>}} // \emph{default:} \code{everything()}

Can either be a series of column names provided in \code{c()}, a vector of
column indices, or a select helper function (e.g. \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=num_range]{num_range()}} and \code{\link[=everything]{everything()}}).}

\item{rows}{\emph{Rows to target}

\code{\link[=rows-columns]{<row-targeting expression>}} // \emph{default:} \code{everything()}

In conjunction with \code{columns}, we can specify which of their rows should
undergo formatting. The default \code{\link[=everything]{everything()}} results in all rows in
\code{columns} being formatted. Alternatively, we can supply a vector of row
captions within \code{c()}, a vector of row indices, or a select helper
function (e.g. \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}). We can also use expressions to filter
down to the rows we need (e.g., \verb{[colname_1] > 100 & [colname_2] < 50}).}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
\code{fmt_units()} lets you better format measurement units in the table body.
These must conform to \strong{gt}'s specialized units notation (e.g.,
\code{"J Hz^-1 mol^-1"} can be used to generate units for the
\emph{molar Planck constant}) for the best conversion. The notation here provides
several conveniences for defining units, so as long as the values to be
formatted conform to this syntax, you'll obtain nicely-formatted units no
matter what the table output format might be (i.e., HTML, LaTeX, RTF, etc.).
Details pertaining to the units notation can be found in the section entitled
\emph{How to use \strong{gt}'s units notation}.
}
\section{How to use \strong{gt}'s units notation}{


The units notation involves a shorthand of writing units that feels familiar
and is fine-tuned for the task at hand. Each unit is treated as a separate
entity (parentheses and other symbols included) and the addition of subscript
text and exponents is flexible and relatively easy to formulate. This is all
best shown with examples:
\itemize{
\item \code{"m/s"} and \code{"m / s"} both render as \code{"m/s"}
\item \code{"m s^-1"} will appear with the \code{"-1"} exponent intact
\item \code{"m /s"} gives the same result, as \code{"/<unit>"} is equivalent to
\code{"<unit>^-1"}
\item \code{"E_h"} will render an \code{"E"} with the \code{"h"} subscript
\item \code{"t_i^2.5"} provides a \code{t} with an \code{"i"} subscript and a \code{"2.5"} exponent
\item \code{"m[_0^2]"} will use overstriking to set both scripts vertically
\item \code{"g/L \%C6H12O6\%"} uses a chemical formula (enclosed in a pair of \code{"\%"}
characters) as a unit partial, and the formula will render correctly with
subscripted numbers
\item Common units that are difficult to write using ASCII text may be implicitly
converted to the correct characters (e.g., the \code{"u"} in \code{"ug"}, \code{"um"},
\code{"uL"}, and \code{"umol"} will be converted to the Greek \emph{mu} symbol; \code{"degC"}
and \code{"degF"} will render a degree sign before the temperature unit)
\item We can transform shorthand symbol/unit names enclosed in \code{":"} (e.g.,
\code{":angstrom:"}, \code{":ohm:"}, etc.) into proper symbols
\item Greek letters can added by enclosing the letter name in \code{":"}; you can
use lowercase letters (e.g., \code{":beta:"}, \code{":sigma:"}, etc.) and uppercase
letters too (e.g., \code{":Alpha:"}, \code{":Zeta:"}, etc.)
\item The components of a unit (unit name, subscript, and exponent) can be
fully or partially italicized/emboldened by surrounding text with \code{"*"} or
\code{"**"}
}
}

\section{Examples}{


Let's use the \code{\link{illness}} dataset and create a new \strong{gt} table. The \code{units}
column contains character values in \strong{gt}'s specialized units notation
(e.g., \code{"x10^9 / L"}) so the \code{fmt_units()} function was used to better format
those units.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{illness |>
  gt() |>
  fmt_units(columns = units) |>
  sub_missing(columns = -starts_with("norm")) |>
  sub_missing(columns = c(starts_with("norm"), units), missing_text = "") |>
  sub_large_vals(rows = test == "MYO", threshold = 1200) |>
  fmt_number(
    decimals = 2,
    drop_trailing_zeros = TRUE
  ) |>
  tab_header(title = "Laboratory Findings for the YF Patient") |>
  tab_spanner(label = "Day", columns = starts_with("day")) |>
  cols_label_with(fn = ~ gsub("day_", "", .)) |>
  cols_merge_range(col_begin = norm_l, col_end = norm_u) |>
  cols_label(
    starts_with("norm") ~ "Normal Range",
    test ~ "Test",
    units ~ "Units"
  ) |>
  cols_width(
    starts_with("day") ~ px(80),
    everything() ~ px(120)
  ) |>
  tab_style(
    style = cell_text(align = "center"),
    locations = cells_column_labels(columns = starts_with("day"))
  ) |>
  tab_style(
    style = cell_fill(color = "aliceblue"),
    locations = cells_body(columns = c(test, units))
  ) |>
  opt_vertical_padding(scale = 0.4) |>
  opt_align_table_header(align = "left") |>
  tab_options(heading.padding = px(10))
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_units_1.png" alt="This image of a table was generated from the first code example in the `fmt_units()` help file." style="width:100\%;">
}}

The \code{\link{constants}} dataset contains values for hundreds of fundamental
physical constants. We'll take a subset of values that have some molar basis
and generate a \strong{gt} table from that. Like the \code{\link{illness}} dataset, this one
has a \code{units} column so, again, the \code{fmt_units()} function will be used to
format those units. Here, the preference for typesetting measurement units is
to have positive and negative exponents (e.g., not \code{"<unit_1> / <unit_2>"}
but rather \code{"<unit_1> <unit_2>^-1"}).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{constants |>
  dplyr::filter(grepl("molar", name)) |>
  gt() |>
  cols_hide(columns = c(uncert, starts_with("sf"))) |>
  fmt_units(columns = units) |>
  fmt_scientific(columns = value, decimals = 3) |>
  tab_header(title = "Physical Constants Having a Molar Basis") |>
  tab_options(column_labels.hidden = TRUE)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_units_2.png" alt="This image of a table was generated from the second code example in the `fmt_units()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

3-20
}

\section{Function Introduced}{

\code{v0.10.0} (October 7, 2023)
}

\seealso{
Other data formatting functions: 
\code{\link{data_color}()},
\code{\link{fmt}()},
\code{\link{fmt_auto}()},
\code{\link{fmt_bins}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_chem}()},
\code{\link{fmt_country}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_date}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_duration}()},
\code{\link{fmt_email}()},
\code{\link{fmt_engineering}()},
\code{\link{fmt_flag}()},
\code{\link{fmt_fraction}()},
\code{\link{fmt_icon}()},
\code{\link{fmt_image}()},
\code{\link{fmt_index}()},
\code{\link{fmt_integer}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_number}()},
\code{\link{fmt_number_si}()},
\code{\link{fmt_partsper}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_roman}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_spelled_num}()},
\code{\link{fmt_tf}()},
\code{\link{fmt_time}()},
\code{\link{fmt_url}()},
\code{\link{sub_large_vals}()},
\code{\link{sub_missing}()},
\code{\link{sub_small_vals}()},
\code{\link{sub_values}()},
\code{\link{sub_zero}()}
}
\concept{data formatting functions}
