% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{ndvi_to_sem}
\alias{ndvi_to_sem}
\title{ndvi_to_sem}
\usage{
ndvi_to_sem(r = NULL, threshold = c(0.2, 0.5), quiet = FALSE)
}
\arguments{
\item{r}{A SpatRaster with single greenspace layer, typically
the output from \code{\link[=get_esa_wc]{get_esa_wc()}}, or \code{\link[=get_s2a_ndvi]{get_s2a_ndvi()}}.}

\item{threshold}{numeric vector of two. Thresholds, defaulting to \code{c(0.2, 0.5)},
for classify two types of vegetation areas according to Hashim et al. (2019):
(1) Non-vegetation (Development and bare land): NDVI values generally below \code{0.2}.
(2) Low vegetation (Shrub and grassland): NDVI values generally between \code{0.2} and \code{0.5}.
(2) High vegetation (Temperate and Tropical urban forest ): NDVI values generally
between \code{0.5} and \code{1.0}.}

\item{quiet}{logical. Whether show progress bars for some process.}
}
\value{
SpatRaster. A raster, where \code{0} represents non-green area, \code{1} represents
shrub and grassland, and \code{2} represents trees.
}
\description{
Convert ndvi raster data into semantic vegetation areas
}
\examples{
sample_data <- terra::rast(system.file("extdata", "detroit_gs.tif", package = "greenSD"))
seg <- ndvi_to_sem(sample_data$`25_NDVI`, threshold = c(0.2, 0.6))

}
\references{
Hashim, H., Abd Latif, Z., & Adnan, N. A. (2019). Urban vegetation classification
with NDVI threshold value method with very high resolution (VHR) Pleiades imagery.
The International Archives of the Photogrammetry, Remote Sensing and Spatial
Information Sciences, 42, 237-240.
}
