% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{get_tile_green}
\alias{get_tile_green}
\title{Classify greenspace based on map tile images}
\usage{
get_tile_green(
  bbox = NULL,
  place = NULL,
  zoom = 17,
  provider = "esri",
  year = NULL,
  quiet = TRUE
)
}
\arguments{
\item{bbox}{\code{sf}, \code{sfc}, or a numeric vector (xmin, ymin, xmax, ymax)
defining the area of interest. Optional if \code{place} is provided.}

\item{place}{character or vector. (optional) A single line address,
e.g. ("1600 Pennsylvania Ave NW, Washington") or a vector of addresses
(c("Madrid", "Barcelona")).}

\item{zoom}{numeric. Zoom level of map tile. The default is \code{17}.}

\item{provider}{character. One of "esri" and "eox".}

\item{year}{integer. The desired year for Sentinel-2 cloudless mosaic
tiles. (This is required when \code{provider = "eox"})}

\item{quiet}{logical. Whether show progress bars for some process.}
}
\value{
A list of two rasters including: greenspace segmentation (where 1 is
green and 0 is non-green) and original map tiles
}
\description{
Generate high-resolution greenspace segmentation using WorldImagery map
tiles provided by esri and Sentinel-2 cloudless mosaic tiles provided
by EOX.
}
\note{
The data derived from Esri WorldImagery may need to include appropriate
Esri copyright notice.
}
\examples{
g <- get_tile_green(
 # bbox = c(-83.087174,42.333373,-83.042542,42.358748),
 zoom = 15
)

}
