% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-Xisoprop.R
\docType{data}
\name{geom_Xisoprop}
\alias{geom_Xisoprop}
\alias{geom_Tisoprop}
\alias{GeomTisoprop}
\alias{geom_Lisoprop}
\alias{GeomLisoprop}
\alias{geom_Risoprop}
\alias{GeomRisoprop}
\title{Fixed Value Isoproportion Lines}
\usage{
geom_Tisoprop(
  mapping = NULL,
  data = NULL,
  ...,
  value,
  na.rm = FALSE,
  show.legend = NA
)

geom_Lisoprop(
  mapping = NULL,
  data = NULL,
  ...,
  value,
  na.rm = FALSE,
  show.legend = NA
)

geom_Risoprop(
  mapping = NULL,
  data = NULL,
  ...,
  value,
  na.rm = FALSE,
  show.legend = NA
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{value}{the isoproportion ratio to draw}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}
}
\description{
Create fixed isoproportion lines for each of the ternary axes, 
\code{geom_Xisoprop(...), (X = T, L, R)} will draw an isoproportion
line projecting from the T, L and R apex respectively.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggtern:::rd_aesthetics("geom", "Tisoprop")}
}

\examples{
data(Feldspar)
ggtern(data = Feldspar, aes(Ab, An, Or)) +
  geom_Tisoprop(value = 0.5) +
  geom_Lisoprop(value = 0.5) +
  geom_Risoprop(value = 0.5) +
  geom_point()
}
\author{
Nicholas Hamilton
}
\keyword{datasets}
