% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_to_ggplot.R
\name{metadata_to_ggplot}
\alias{metadata_to_ggplot}
\title{Convert ggsem workflow metadata directly to a ggplot object}
\usage{
metadata_to_ggplot(
  metadata,
  element_order = c("lines", "points", "loops", "annotations"),
  zoom_level = 1,
  horizontal_position = 0,
  vertical_position = 0,
  n = 100
)
}
\arguments{
\item{metadata}{A list containing ggsem workflow metadata, typically loaded from
an RDS file saved by the ggsem Shiny app using the "Export Workflow" functionality or the files directory.}

\item{element_order}{A character vector specifying the order in which graphical elements are added to the plot.
For example: \code{c("annotations", "loops", "lines", "points")}. Elements at the front appear on top. Default includes all elements.}

\item{zoom_level}{A numeric value controlling the zoom level of the plot. A value >1 zooms in; <1 zooms out. Default is \code{1}.}

\item{horizontal_position}{A numeric value to shift the plot horizontally. Default is \code{0}.}

\item{vertical_position}{A numeric value to shift the plot vertically. Default is \code{0}.}

\item{n}{Number of points used for interpolation in gradient or curved lines. Default is \code{100}.}
}
\value{
A ggplot object with an \code{axis_ranges} attribute specifying the x and y axis ranges after adjustments.
}
\description{
This function is a convenient wrapper that takes ggsem workflow metadata,
extracts the visualization data silently, and converts it to a ggplot object
in one step.
}
\details{
This function combines the functionality of \code{\link{ggsem_silent}} and \code{\link{csv_to_ggplot}}
into a single convenient call. It's useful when you want to go directly from saved workflow
metadata to a ggplot object without intermediate steps.
}
\examples{
\dontrun{
# Load a saved ggsem workflow
workflow_metadata <- readRDS("ggsem_workflow_metadata.rds")

# Convert directly to ggplot
p <- metadata_to_ggplot(
  metadata = workflow_metadata
)

# Customize the plot further
p + ggtitle("My SEM Visualization")
}
}
