% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-pattern-auto.R, R/scale-pattern.R
\name{scale_discrete}
\alias{scale_discrete}
\alias{scale_pattern_type_continuous}
\alias{scale_pattern_type_discrete}
\alias{scale_pattern_subtype_continuous}
\alias{scale_pattern_subtype_discrete}
\alias{scale_pattern_filename_continuous}
\alias{scale_pattern_filename_discrete}
\alias{scale_pattern_filter_continuous}
\alias{scale_pattern_filter_discrete}
\alias{scale_pattern_gravity_continuous}
\alias{scale_pattern_gravity_discrete}
\alias{scale_pattern_orientation_continuous}
\alias{scale_pattern_orientation_discrete}
\alias{scale_pattern_grid_continuous}
\alias{scale_pattern_grid_discrete}
\alias{scale_pattern_units_continuous}
\alias{scale_pattern_units_discrete}
\alias{scale_pattern_continuous}
\alias{scale_pattern_discrete}
\title{Scales for discrete pattern aesthetics}
\usage{
scale_pattern_type_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  choices = NULL,
  trans = deprecated(),
  guide = "legend",
  ...,
  transform = "identity"
)

scale_pattern_type_discrete(..., choices = NULL, guide = "legend")

scale_pattern_subtype_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  choices = NULL,
  trans = deprecated(),
  guide = "legend",
  ...,
  transform = "identity"
)

scale_pattern_subtype_discrete(..., choices = NULL, guide = "legend")

scale_pattern_filename_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  choices = NULL,
  trans = deprecated(),
  guide = "legend",
  ...,
  transform = "identity"
)

scale_pattern_filename_discrete(..., choices = NULL, guide = "legend")

scale_pattern_filter_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  choices = c("lanczos", "box", "spline", "cubic"),
  trans = deprecated(),
  guide = "legend",
  ...,
  transform = "identity"
)

scale_pattern_filter_discrete(
  ...,
  choices = c("lanczos", "box", "spline", "cubic"),
  guide = "legend"
)

scale_pattern_gravity_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  choices = c("center", "north", "south", "east", "west", "northeast", "northwest",
    "southeast", "southwest"),
  trans = deprecated(),
  guide = "legend",
  ...,
  transform = "identity"
)

scale_pattern_gravity_discrete(
  ...,
  choices = c("center", "north", "south", "east", "west", "northeast", "northwest",
    "southeast", "southwest"),
  guide = "legend"
)

scale_pattern_orientation_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  choices = c("horizontal", "vertical", "radial"),
  trans = deprecated(),
  guide = "legend",
  ...,
  transform = "identity"
)

scale_pattern_orientation_discrete(
  ...,
  choices = c("horizontal", "vertical", "radial"),
  guide = "legend"
)

scale_pattern_grid_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  choices = c("square", "hex"),
  trans = deprecated(),
  guide = "legend",
  ...,
  transform = "identity"
)

scale_pattern_grid_discrete(
  ...,
  choices = c("square", "hex"),
  guide = "legend"
)

scale_pattern_units_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  choices = c("snpc", "cm", "inches"),
  trans = deprecated(),
  guide = "legend",
  ...,
  transform = "identity"
)

scale_pattern_units_discrete(
  ...,
  choices = c("snpc", "cm", "inches"),
  guide = "legend"
)

scale_pattern_continuous(
  name = waiver(),
  breaks = waiver(),
  labels = waiver(),
  limits = NULL,
  choices = c("stripe", "crosshatch", "circle"),
  trans = deprecated(),
  guide = "legend",
  ...,
  transform = "identity",
  na.value = "none"
)

scale_pattern_discrete(
  ...,
  choices = c("stripe", "crosshatch", "circle"),
  guide = "legend",
  na.value = "none"
)
}
\arguments{
\item{name, breaks, labels, limits, trans, guide, ..., transform, na.value}{See
\code{{ggplot2}} documentation for more information on scales.}

\item{choices}{vector of values to choose from.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale} object.
}
\description{
Scales for discrete pattern aesthetics
}
\examples{
  if (require('ggplot2')) {
    gg <- ggplot(mtcars) +
       geom_density_pattern(
         aes(
           x            = mpg,
           pattern_fill = as.factor(cyl),
           pattern_type = as.factor(cyl)
         ),
         pattern = 'polygon_tiling',
         pattern_key_scale_factor = 1.2
       ) +
       scale_pattern_type_discrete(choices = gridpattern::names_polygon_tiling) +
       theme_bw(18) +
       theme(legend.key.size = unit(2, 'cm')) +
       labs(
         title    = 'ggpattern::geom_density_pattern()',
         subtitle = 'pattern = \'polygon_tiling\''
       )
    plot(gg)
  }
}
