% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blend_custom.R
\name{with_blend_custom}
\alias{with_blend_custom}
\title{Create a custom blend type}
\usage{
with_blend_custom(
  x,
  bg_layer,
  a = 0,
  b = 0,
  c = 0,
  d = 0,
  flip_order = FALSE,
  alpha = NA,
  ...
)
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{bg_layer}{The background layer to use. Can either be a string
identifying a registered filter, or a raster object. The map will be resized
to match the dimensions of x.}

\item{a, b, c, d}{The coefficients defining the blend operation}

\item{flip_order}{Should the order of the background and the overlay be
flipped so that \code{bg_layer} is treated as being on top and \code{x} being below.}

\item{alpha}{For non-Duff-Porter blends the alpha channel may become modified.
This argument can be used to set the resulting alpha channel to that of the
source (\code{"src"}) or destination (\code{"dst"})}

\item{...}{Arguments to be passed on to methods. See
\link[=object_support]{the documentation of supported object} for a description of
object specific arguments.}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
Many of the blend types available in \code{\link[=with_blend]{with_blend()}} are variations over the
formula: \code{a*src*dst + b*src + c*dst + d}, where \code{src} stands for the channel
value in the source image and \code{dst} stands for the destination image (the
background). Multiply is e.g. defined as \verb{a:1, b:0, c:0, d:0}. This filter
gives you free reign over setting the coefficient of the blend calculation.
}
\examples{
library(ggplot2)
ggplot(mpg, aes(class, hwy)) +
  as_reference(geom_boxplot(fill = 'green'), 'box') +
  with_blend_custom(geom_point(colour = 'red'),
                    bg_layer = 'box', a = -0.5, b = 1, c = 1)

}
\seealso{
Other blend filters: 
\code{\link{with_blend}()},
\code{\link{with_interpolate}()},
\code{\link{with_mask}()}
}
\concept{blend filters}
