% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-nesting-utils.R
\docType{data}
\name{position_nest}
\alias{position_nest}
\alias{PositionNest}
\title{Any combination of nested positions}
\usage{
position_nest(position = "identity_identity")
}
\arguments{
\item{position}{a character of the nested position you want to use}
}
\value{
A ggplot2 position
}
\description{
This function lets you nest any two positions available in ggplot2 (your
results may vary). This allows you to set different position adjustments 
for the "main" and "distribution" parts of your plot.
}
\examples{
# nested positions allows us to differentiate which postion adjustments
# are used for the plot groups vs the distribution samples
library(ggplot2)
ggplot(uncertain_mpg, aes(class)) + 
  geom_bar_sample(aes(fill = drv), alpha=0.9,
                  position = position_nest("stack_dodge"))
}
\keyword{datasets}
