% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-interpolation.R
\name{compare_interpolation_methods}
\alias{compare_interpolation_methods}
\title{Compare interpolation methods}
\usage{
compare_interpolation_methods(
  spatial_data,
  target_variable,
  methods = c("NN", "simple", "spline"),
  cv_folds = 5,
  verbose = TRUE
)
}
\arguments{
\item{spatial_data}{Spatial data for interpolation}

\item{target_variable}{Variable to interpolate}

\item{methods}{Vector of methods to compare}

\item{cv_folds}{Number of cross-validation folds}

\item{verbose}{Print comparison results}
}
\value{
Data frame with method comparison results
}
\description{
Compare multiple interpolation methods using cross-validation and
return performance metrics for method selection.
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# Compare interpolation methods
method_comparison <- compare_interpolation_methods(
  soil_data,
  target_variable = "nitrogen",
  methods = c("NN", "simple", "spline"),
  cv_folds = 10
)

# View results
print(method_comparison)
# Best method
best_method <- method_comparison$method[which.min(method_comparison$rmse)]
}

}
