% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tostring.R
\name{propose_column_widths}
\alias{propose_column_widths}
\title{Propose column widths based on the \code{MatrixPrintForm} of an object}
\usage{
propose_column_widths(
  x,
  indent_size = 2,
  fontspec = font_spec(),
  round_type = obj_round_type(x)
)
}
\arguments{
\item{x}{(\code{ANY})\cr a \code{MatrixPrintForm} object, or an object with a \code{matrix_form} method.}

\item{indent_size}{(\code{numeric(1)})\cr indent size, in characters. Ignored when \code{x} is already
a \code{MatrixPrintForm} object in favor of information there.}

\item{fontspec}{(\code{font_spec})\cr a font_spec object specifying the font information to use for
calculating string widths and heights, as returned by \code{\link[=font_spec]{font_spec()}}.}

\item{round_type}{(\code{string})\cr .
\cr The type of rounding to perform. Allowed values: (\code{"iec"}, \code{"iec_mod"} or \code{"sas"})
\cr iec, the default, and iec_mod performs rounding compliant with IEC 60559
(see notes in \code{\link[=round_fmt]{round_fmt()}}), while
sas performs nearest-value rounding consistent with rounding within SAS.\cr
In addition, the rounding of a negative number that rounds to zero will be presented as 0
(with the appropriate number of trailing zeros) for both \code{sas} and \code{iec_mod},
while for \code{iec}, it will be presented as -0 (with the appropriate number of trailing zeros).}
}
\value{
A vector of column widths based on the content of \code{x} for use in printing and pagination.
}
\description{
Row names are also considered a column for the output.
}
\examples{
mf <- basic_matrix_form(mtcars)
propose_column_widths(mf)

}
