% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prederr.R
\name{prederr}
\alias{prederr}
\title{prederr}
\usage{
prederr(
  msdata,
  X,
  beta_est,
  times,
  state_of_interest,
  trans_matrix,
  test_fraction = 0.2,
  quick = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{msdata}{is a multi-state model in extended form having columns Tstart,Tstop,trans (covariates expanded transition wise)}

\item{X}{covariate matrix of the original covariates before expanding, (for example if the dataset initially contains 4 covariates then the matrix has to be formed with the 4 covariates only and not their expanded version )}

\item{beta_est}{estimated beta coefficients from the fitted model}

\item{times}{time points at which prediction error is to be calculated}

\item{state_of_interest}{the target state for which prediction accuracy is evaluated}

\item{trans_matrix}{transition matrix initially defined for multi-state model}

\item{test_fraction}{fraction of subjects randomly assigned to test set}

\item{quick}{specify whether the model will run complete code or quick mode}

\item{verbose}{Logical indicating whether to print progress messages}
}
\value{
Gives a list of objects like brier score at specified time points, Integrated Brier score,predicted probabilities, their true states and the time points
}
\description{
Evaluates the predictive performance of the multi-state model
}
\details{
This function is designed to evaluate the predictive performance of a multi-state
survival model using Brier score using subject specific covatiates and thier estimated
coefficients from a penalized regression model. It also incorporates baseline hazards for each
transtion from a Cox model using msfit() for more accurate prediction and also computes the
predicted state probabilities with probtrans().
}
\examples{
##
set.seed(123)
data(msdata_3state)
tmat_3state <- mstate::transMat(x = list(c(2, 3), c(3), c()),
                       names = c("State1", "State2", "State3"))
beta_est1 <- c(0.13, -0.16, -0.12, -0.20, -0.15, -0.55)
prederr(msdata = msdata_3state, X = msdata_3state[, 9:10], beta_est = beta_est1,
times = seq(0.5, 1.5, length.out = 5),state_of_interest = 2,
trans_matrix = tmat_3state,test_fraction = 0.2,quick = TRUE,verbose = TRUE)

\donttest{
data(msdata_4state)
set.seed(123)
sub_msdata_4state <- msdata_4state[msdata_4state$id \%in\% sample(unique(msdata_4state$id), 10), ]
tmat_4state <- mstate::transMat(x = list(c(2, 3, 4,5), c(3, 4, 5), c(4,5), c(5),c()),
                               names = c("Tx", "Lrc","Fp", "Dp", "srv"))
beta_est1 <- as.numeric (c(0.13,-0.16,-0.12,-0.20,-0.15,-0.55,-0.35,-0.28,-0.34,-0.12))
times1 <- seq(0.5, 1.5, length.out = 5)
prederr(msdata = sub_msdata_4state, X = sub_msdata_4state[,9],
       beta_est = beta_est1,times = times1,state_of_interest = 2,
       trans_matrix = tmat_4state,test_fraction = 0.2,quick = TRUE,verbose = TRUE)
}
##

}
\author{
Atanu Bhattacharjee,Gajendra Kumar Vishwakarma,Abhipsa Tripathy
}
