% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fjoin_functions.R
\name{fjoin_right_anti}
\alias{fjoin_right_anti}
\title{Right anti-join}
\usage{
fjoin_right_anti(
  x = NULL,
  y = NULL,
  on,
  match.na = FALSE,
  mult.x = "all",
  mult.y = "all",
  select = NULL,
  do = !(is.null(x) && is.null(y)),
  show = !do
)
}
\arguments{
\item{x, y}{\code{data.frame}-like objects (plain, \code{data.table},
tibble, \code{sf}, \code{list}, etc.) or else both omitted for a mock join
statement with no data. See Details.}

\item{on}{A character vector of join predicates, e.g. \code{c("id", "col_x ==
col_y", "date > date", "cost <= budget")}, or else \code{NA} for a natural
join (an equality join on all same-named columns).}

\item{match.na}{Whether to allow equality matches between \code{NA}s or
\code{NaN}s. Default \code{FALSE}.}

\item{mult.x, mult.y}{When a row of \code{x} (\code{y}) has multiple matching
rows in \code{y} (\code{x}), which to accept: \code{"all"} (the default),
\code{"first"}, or \code{"last"}. May be used in combination.}

\item{select}{Character vector of columns to be selected from \code{y}.
\code{NULL} (the default) selects all columns. Join columns are always
selected.}

\item{do}{Whether to execute the join. If \code{FALSE}, \code{show} is set to
\code{TRUE} and the \pkg{data.table} code for the join is printed to the
console instead. Default is \code{TRUE} unless \code{x} and \code{y} are
both omitted/\code{NULL}, in which case a mock join statement is produced.
See Details.}

\item{show}{Whether to print the \pkg{data.table} code for the join to the
console. Default is the opposite of \code{do}. If \code{x} and \code{y} are
both omitted/\code{NULL}, mock join code is displayed.}
}
\value{
A \code{data.frame}, \code{data.table}, (grouped) tibble, \code{sf},
or \code{sf}-tibble, or else \code{NULL} if \code{do} is \code{FALSE}. See
Details.
}
\description{
The anti-join of \code{y} in a join of \code{x} and \code{y}, i.e. the rows
  of \code{y} that do not join.
}
\details{
Details are as for e.g. \code{\link{fjoin_inner}} except for arguments
controlling the order and prefixing of output columns, which do not apply.
Output class is determined by \code{y}.
}
\examples{
# ---------------------------------------------------------------------------
# Semi- and anti-joins: basic usage
# ---------------------------------------------------------------------------

# data frames
x <- data.table::fread(data.table = FALSE, input = "
country   pop_m
Australia  27.2
Brazil    212.0
Chad        3.0
")

y <- data.table::fread(data.table = FALSE, input = "
country forest_pc
Brazil       59.1
Chad          3.2
Denmark      15.8
")

# full join with `indicate = TRUE` for comparison
fjoin_full(x, y, on = "country", indicate = TRUE)

fjoin_semi(x, y, on = "country")
fjoin_anti(x, y, on = "country")
fjoin_right_semi(x, y, on = "country")
fjoin_right_anti(x, y, on = "country")

# ---------------------------------------------------------------------------
# `mult.x` and `mult.y` support
# ---------------------------------------------------------------------------

# data frames
events <- data.table::fread(data.table = FALSE, input = "
event_id event_ts
       1       10
       2       20
       3       40
")

reactions <- data.table::fread(data.table = FALSE, input = "
reaction_id reaction_ts
          1          30
          2          50
          3          60
")
# ---------------------------------------------------------------------------

# for each event, the next reaction, provided there was no intervening event (1:1)
fjoin_full(
  events,
  reactions,
  on = c("event_ts < reaction_ts"),
  mult.x = "first",
  mult.y = "last",
  indicate = TRUE
)

fjoin_semi(
  events,
  reactions,
  on = c("event_ts < reaction_ts"),
  mult.x = "first",
  mult.y = "last"
)

fjoin_anti(
  events,
  reactions,
  on = c("event_ts < reaction_ts"),
  mult.x = "first",
  mult.y = "last"
)

# ---------------------------------------------------------------------------
# Natural join
# ---------------------------------------------------------------------------
fjoin_semi(x, y, on = NA)

fjoin_anti(x, y, on = NA)

# ---------------------------------------------------------------------------
# Mock join
# ---------------------------------------------------------------------------
fjoin_semi(on="id")

fjoin_semi(on=c("id", "date"))

fjoin_semi(on=c("id"), mult.y = "last")

}
\seealso{
See the package-level documentation \code{\link{fjoin}} for related
 functions.
}
