% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_models.R
\name{train_models}
\alias{train_models}
\title{Train Individual Models}
\usage{
train_models(
  run_info,
  run_global_models = FALSE,
  run_local_models = TRUE,
  global_model_recipes = c("R1"),
  feature_selection = FALSE,
  negative_forecast = FALSE,
  parallel_processing = NULL,
  inner_parallel = FALSE,
  num_cores = NULL,
  seed = 123
)
}
\arguments{
\item{run_info}{run info using the \code{\link[=set_run_info]{set_run_info()}} function}

\item{run_global_models}{If TRUE, run multivariate models on the entire data
set (across all time series) as a global model. Can be override by
models_not_to_run. Default of NULL runs global models for all date types
except week and day.}

\item{run_local_models}{If TRUE, run models by individual time series as
local models.}

\item{global_model_recipes}{Recipes to use in global models.}

\item{feature_selection}{Implement feature selection before model training}

\item{negative_forecast}{If TRUE, allow forecasts to dip below zero.}

\item{parallel_processing}{Default of NULL runs no parallel processing and
forecasts each individual time series one after another. 'local_machine'
leverages all cores on current machine Finn is running on. 'spark'
runs time series in parallel on a spark cluster in Azure Databricks or
Azure Synapse.}

\item{inner_parallel}{Run components of forecast process inside a specific
time series in parallel. Can only be used if parallel_processing is
set to NULL or 'spark'.}

\item{num_cores}{Number of cores to run when parallel processing is set up.
Used when running parallel computations on local machine or within Azure.
Default of NULL uses total amount of cores on machine minus one. Can't be
greater than number of cores on machine minus 1.}

\item{seed}{Set seed for random number generator. Numeric value.}
}
\value{
trained model outputs are written to disk.
}
\description{
Train Individual Models
}
\examples{
\donttest{
data_tbl <- timetk::m4_monthly \%>\%
  dplyr::rename(Date = date) \%>\%
  dplyr::mutate(id = as.character(id)) \%>\%
  dplyr::filter(
    Date >= "2013-01-01",
    Date <= "2015-06-01"
  )

run_info <- set_run_info()

prep_data(run_info,
  input_data = data_tbl,
  combo_variables = c("id"),
  target_variable = "value",
  date_type = "month",
  forecast_horizon = 3
)

prep_models(run_info,
  models_to_run = c("arima", "glmnet"),
  num_hyperparameters = 2,
  back_test_scenarios = 6,
  run_ensemble_models = FALSE
)

train_models(run_info)
}
}
