% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desirability2.R
\name{show_best_desirability_num}
\alias{show_best_desirability_num}
\title{Show best desirability scores, based on number of predictors \emph{(plural)}}
\usage{
show_best_desirability_num(x, ..., num_terms = 5)
}
\arguments{
\item{x}{A tibble or data frame returned by \code{\link[=fill_safe_values]{fill_safe_values()}}.}

\item{...}{One or more desirability selectors to configure the optimization.}

\item{num_terms}{An integer value specifying the number
of predictors to consider.}
}
\value{
A tibble with \code{num_terms}
number of rows. When showing the results,
the metrics are presented in "wide format" (one column per metric) and there
are new columns for the corresponding desirability values (each starts with
\code{.d_}).
}
\description{
Similar to \code{\link[=show_best_desirability_prop]{show_best_desirability_prop()}} that can
simultaneously optimize multiple scores using desirability functions.
See \code{\link[=show_best_score_num]{show_best_score_num()}} for \emph{singular} scoring method.
}
\details{
See \code{\link[=show_best_desirability_prop]{show_best_desirability_prop()}} for details.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(desirability2)
library(dplyr)

# Remove outcome
ames_scores_results <- ames_scores_results |>
  dplyr::select(-outcome)
ames_scores_results

show_best_desirability_num(
  ames_scores_results,
  maximize(cor_pearson, low = 0, high = 1)
)

show_best_desirability_num(
  ames_scores_results,
  maximize(cor_pearson, low = 0, high = 1),
  maximize(imp_rf)
)

show_best_desirability_num(
  ames_scores_results,
  maximize(cor_pearson, low = 0, high = 1),
  maximize(imp_rf),
  maximize(infogain)
)

show_best_desirability_num(
  ames_scores_results,
  maximize(cor_pearson, low = 0, high = 1),
  maximize(imp_rf),
  maximize(infogain),
  num_terms = 2
)

show_best_desirability_num(
  ames_scores_results,
  target(cor_pearson, low = 0.2, target = 0.255, high = 0.9)
)

show_best_desirability_num(
  ames_scores_results,
  constrain(cor_pearson, low = 0.2, high = 1)
)
\dontshow{\}) # examplesIf}
}
