% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eda-white-test.R
\name{eda_white_test}
\alias{eda_white_test}
\title{White Test for Heteroskedasticity}
\usage{
eda_white_test(data, years, alpha = 0.05)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{years}{Numeric vector of observation years corresponding to \code{data}.
Must be the same length as \code{data} and strictly increasing.}

\item{alpha}{Numeric scalar in \eqn{[0.01, 0.1]}. The significance
level for confidence intervals or hypothesis tests. Default is 0.05.}
}
\value{
A list containing the results of the White test:
\itemize{
\item \code{data}: The \code{data} argument.
\item \code{years}: The \code{years} argument.
\item \code{alpha}: The significance level as specified in the \code{alpha} argument.
\item \code{null_hypothesis}: A string describing the null hypothesis.
\item \code{alternative_hypothesis}: A string describing the alternative hypothesis.
\item \code{statistic}: White test statistic based on sample size and \code{r_squared}.
\item \code{p_value}: The p-value derived from a Chi-squared distribution with \code{df = 2}.
\item \code{reject}: If \code{TRUE}, the null hypothesis was rejected at significance \code{alpha}.
}
}
\description{
Performs the White test for heteroskedasticity by regressing the squared residuals
of a linear model on the original regressors and their squared terms. The null
hypothesis is homoskedasticity.
}
\details{
The White test regresses the squared residuals from a primary linear model
\code{lm(data ~ years)} against both the original regressor and its square.
The test statistic is calculated as \eqn{nR^2}, where \eqn{R^2} is the
coefficient of determination from the auxiliary regression and \eqn{n} is
the number of elements in the time series. Under the null hypothesis, the
test statistic has the \eqn{\chi^2} distribution with 2 degrees of freedom.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
years <- seq(from = 1901, to = 2000)
eda_white_test(data, years)

}
\references{
White, H. (1980). A heteroskedasticity-consistent covariance matrix estimator and
a direct test for heteroskedasticity. \emph{Econometrica}, 48(4), 817–838.
}
\seealso{
\code{\link[stats:lm]{stats::lm()}}, \code{\link[stats:Chisquare]{stats::pchisq()}}
}
