% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zonalGeog.r
\name{zonalGeog,GRaster-method}
\alias{zonalGeog,GRaster-method}
\alias{zonalGeog}
\title{Geographic statistics for sets of cells with the same values}
\usage{
\S4method{zonalGeog}{GRaster}(x, unit = "meters")
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{unit}{Character: Units of the output. Any of:
\itemize{
\item \code{"meters"} (default)
\item \code{"kilometers"} or \code{"km"}
\item \code{"miles"} or \code{"mi"}
\item \code{"yards"} or \code{"yd"}
\item \code{"feet"} or \code{"ft"}: International foot; 1 foot exactly equal to 0.3048 meters
\item \code{"cells"}: Number or cells
}

Partial matching is used and case is ignored.}
}
\value{
A list of \code{data.frame}s or a \code{data.table}s, one per layer in \code{x}. Only layers that are integers or factors have their geographies calculated. Other layers have \code{NULL} tables returned.
}
\description{
This function calculates geographic statistics for each set of cells in an \code{integer} or \code{factor} \code{GRaster}. Statistics include:
\itemize{
\item Area
\item Perimeter length
\item "Compact square" statistic: \eqn{4 \sqrt(area) / perimeter)}
\item "Compact circle" statistic: \eqn{4 * P / ( 2 \sqrt(\pi * A))} where \emph{P} is the perimeter length and \emph{A} the area.
\item fractal dimension: \eqn{2 ( log(P) / log(A + 0.001))} where \emph{P} is perimeter length and \emph{A} is area.
\item The average x- and y-coordinates of each zone.
}
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data: Elevation and land cover
madElev <- fastData("madElev")
madForest2000 <- fastData("madForest2000")
madCover <- fastData("madCover")

# Convert to GRasters:
elev <- fast(madElev)
forest2000 <- fast(madForest2000)
cover <- fast(madCover)

# Rename
names(elev) <- "elev"
names(forest2000) <- "forest"

# Geometric statistics for an integer raster zoned by elevation:
fun <-
  "= if (elev <400 & forest == 1, 0, if (elev >=400 & forest == 1, 1, null()))"
forestByElev <- app(c(elev, forest2000), fun = fun)
plot(forestByElev, main = "forest < 400 m & >= 400 m")
zonalGeog(forestByElev)

# Geometric statistics for a categorical raster:
zonalGeog(cover)

}
}
