% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/focal.r
\name{focal,GRaster-method}
\alias{focal,GRaster-method}
\alias{focal}
\title{Calculate cell values based on values of nearby cells}
\usage{
\S4method{focal}{GRaster}(x, w = 3, fun = "sum", circle = FALSE, quantile = 0.5)
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{w}{Numeric integer or a square matrix with an odd number of rows and columns: The size and nature of the neighborhood:
\itemize{
\item "Square" neighborhoods (when \code{circle = FALSE}): An odd integer >= 3, indicating indicates the size of a "square" neighborhood (number of cells wide and number or cells tall).
\item "Circular" neighborhoods (when \code{circle = TRUE}): An odd integer >=3, indicating the diameter of the circle.
\item A matrix of cell weights: The matrix must be square and have an odd number of rows and columns (example: \code{matrix(c(0.5, 1, 0.5, 1, 2, 1, 0.5, 1, 0.5), nrow=3)}). You cannot use a weights matrix when \code{circle = TRUE}. Cells with \code{NA} as a weight will be ignored. Note that weighted matrices should not be used for function \code{min}, \code{max}, \code{count}, \code{nunique}, or \code{interspersion}.
}}

\item{fun}{Character: Name of the function to apply to the neighborhood:
\itemize{
\item "\code{mean}" (default)
\item "\code{median}"
\item "\code{mode}"
\item "\code{min}" or "\code{max}": Minimum or maximum. Should not use a weights matrix.
\item "\code{range}": Difference between the maximum and minimum.  Should not use a weights matrix.
\item "\code{sd}": Sample standard deviation.  NB: This is the same as the \code{\link[stats:sd]{stats::sd()}} function.
\item "\code{sdpop}": Population standard deviation. NB: This is the same as the function "stddev" in the \strong{GRASS} tool \code{r.neighbors}.
\item "\code{sum}": Sum of non-`NA`` cells.
\item "\code{count}": Number of non-`NA cells. Should not use a weights matrix.
\item "\code{var}": Sample variance.  NB: This is the same as the \code{\link[stats:cor]{stats::var()}} function.
\item "\code{varpop}": Population variance. NB: This is the same as the function "variance" in the \strong{GRASS} tool \code{r.neighbors}.
\item "\code{nunique}": Number of unique values. Should not use a weights matrix.
\item "\code{interspersion}": Proportion of cells with values different from focal cell (e.g., if 6 of 8 cells have different values, then the interspersion is 6/8 = 0.75). NB: This is slightly different from how it is defined in the \strong{GRASS} tool \code{r.neighbors}. Should not use a weights matrix.
\item "\code{quantile}": Quantile of values. The value in argument \code{quantile} is used to specify the quantile.
}

The center cell value is always included in the calculations, and all calculations ignore \code{NA} cells (i.e., they do not count as cells in the focal neighborhood).}

\item{circle}{Logical: If \code{FALSE} (default), use a square neighborhood. If \code{TRUE}, use a circular neighborhood. When this is \code{TRUE}, argument \code{w} cannot be a matrix.}

\item{quantile}{Numeric between 0 and 1, inclusive: Quantile to calculate when \code{fun = "quantile"}. The default value is 0.5 (median), and valid values must be in the range between 0 and 1, inclusive.}
}
\value{
A \code{GRaster}.
}
\description{
This function calculates statistics on a moving "neighborhood" of cells of a raster. The neighborhood can be a square, circle, or a user-defined set of cells (with or without weights).
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster:
elev <- fast(madElev)

# Focal calculations:
sums <- focal(elev, fun = "sum")
means <- focal(elev, fun = "mean")

# Focal calculations on a circular window:
sds <- focal(elev, fun = "sd") # square
sdsCircle <- focal(elev, fun = "sd", circle = TRUE) # circle

sds
sdsCircle

plot(sds - sdsCircle)

# Focal calculations with user-defined weights:
w <- matrix(c(1, 0, 1, 0, 1, 0, 1, 0, 1), ncol = 3)
w
sumsWeighted <- focal(elev, fun = "sum", w = w)

s <- c(sums, sumsWeighted)
minmax(s)

}
}
\seealso{
\code{\link[terra:focal]{terra::focal()}}, \strong{GRASS} manual page for tool \code{r.neighbors} (see \code{grassHelp("r.neighbors")})
}
