% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convHull.r
\name{convHull,GVector-method}
\alias{convHull,GVector-method}
\alias{convHull}
\title{Minimum convex hull around a spatial vector}
\usage{
\S4method{convHull}{GVector}(x, by = "")
}
\arguments{
\item{x}{A \code{GVector}.}

\item{by}{Character: If \code{""} (default), then a convex hull is created for all geometries together. Otherwise, this is the name of a field in the vector. Hulls will be created for each set of geometries with the same value in this column.}
}
\value{
A \code{GVector}.
}
\description{
Create a minimum convex hull around a spatial vector.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Points vector of specimens of species in the plant genus Dypsis
madDypsis <- fastData("madDypsis")

# Convert sf to a GVector:
dypsis <- fast(madDypsis)

### Convex hull for all plant specimens together:
ch <- convHull(dypsis)

### Convex hull for each species:
head(dypsis) # See the "rightsHolder" column?
chHolder <- convHull(dypsis, by = "rightsHolder")

### Plot:
plot(dypsis)
plot(ch, add = TRUE)
n <- length(chHolder)
for (i in 1:n) {
   plot(chHolder[[i]], border = i, add = TRUE)
}

}
}
\seealso{
\code{link[terra]{convHull}}, \code{link[sf]{st_convex_hull}}, tool \code{v.hull} in \strong{GRASS} (see \code{grassHelp("v.hull")})
}
