% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.lines.r
\name{as.lines,GRaster-method}
\alias{as.lines,GRaster-method}
\alias{as.lines}
\title{Convert a raster to a lines vector}
\usage{
\S4method{as.lines}{GRaster}(x)
}
\arguments{
\item{x}{A \code{GRaster}. If more than one layer is in the \code{GRaster}, only the first will be used (with a warning).}
}
\value{
A \code{GVector}.
}
\description{
\code{\link[=as.lines]{as.lines()}} converts a \code{GRaster} to a "lines" \code{GVector}. Before you apply this function, you may need to run \code{\link[=thinLines]{thinLines()}} on the raster to reduce linear features to a single-cell width. You may also need to use \link[=breakPolys]{clean geometry} (especially the \code{\link[=removeDups]{removeDups()}} and \code{\link[=removeDangles]{removeDangles()}}) afterward to remove duplicated vertices and "dangling" lines.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Elevation
madElev <- fastData("madElev")

# Convert to GRaster:
elev <- fast(madElev)

# Thin elevation raster:
thinned <- thinLines(elev, iter = 300)
plot(thinned)

# Convert to lines:
rastToLines <- as.lines(thinned)
plot(rastToLines)

# We can clean this:
cleanLines <- fixDangles(x = rastToLines)
plot(rastToLines, col = "red")
plot(cleanLines, add = TRUE)

}
}
\seealso{
\code{\link[=as.points]{as.points()}}, \code{\link[=as.polygons]{as.polygons()}}, \code{\link[terra:as.lines]{terra::as.lines()}}, \code{\link[=thinLines]{thinLines()}}, \link[=breakPolys]{geometry cleaning}, and \strong{GRASS} tool \code{r.to.vect}
}
