% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addTable_dropTable.r
\name{addTable<-,GVector,data.frame-method}
\alias{addTable<-,GVector,data.frame-method}
\alias{addTable<-}
\alias{addTable<-,GVector,data.table-method}
\alias{addTable<-,GVector,matrix-method}
\alias{dropTable,GVector-method}
\alias{dropTable}
\title{Attach or detach GVector's data table}
\usage{
\S4method{addTable}{GVector,data.frame}(x, ...) <- value

\S4method{addTable}{GVector,data.table}(x, ...) <- value

\S4method{addTable}{GVector,matrix}(x, ...) <- value

\S4method{dropTable}{GVector}(x)
}
\arguments{
\item{x}{A \code{GVector}.}

\item{...}{Other arguments (ignored).}

\item{value}{A \code{data.frame}, \code{data.table}, or \code{matrix}.}
}
\value{
A \code{GVector}.
}
\description{
\code{addTable()} adds an entire table to a \code{GVector}. It will replace any existing table. There must be one row in the table for each geometry (see \code{\link[=ngeom]{ngeom()}}). You can also add a table column-by-column using the \code{\link[fasterRaster]{$<-}} operator.

\code{dropTable()} removes a data table associated with a \code{GVector}.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Rivers vector
madRivers <- fastData("madRivers")

# Convert sf to a GVector
rivers <- fast(madRivers)

# Convert GVector to data.frame or data.table
as.data.frame(rivers)
as.data.table(rivers)

# Subset rivers vector
rivers1 <- rivers[1:2]
rivers2 <- rivers[10:11]

# Concatenate rivers
riversCombo <- rbind(rivers1, rivers2)
riversCombo

# Add columns
newCol <- data.frame(new = 1:11)
riversCol <- colbind(rivers, newCol)
riversCol

# Remove table
riversCopy <- rivers
riversCopy # has data table
riversCopy <- dropTable(riversCopy)
riversCopy # no data table

# Add a new table
newTable <- data.frame(num = 1:11, letters = letters[1:11])
addTable(riversCopy) <- newTable
riversCopy

}
}
\seealso{
\code{\link[fasterRaster]{$<-}}, \code{\link[=colbind]{colbind()}}, \code{\link[=rbind]{rbind()}}, \code{\link[=as.data.frame]{as.data.frame()}}, \code{\link[=as.data.table]{as.data.table()}}
}
