% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_gnn_results.R
\name{analyse_gnn_results}
\alias{analyse_gnn_results}
\title{Analyse and Visualise GNN Results}
\usage{
analyse_gnn_results(
  gnn_results,
  prepared_data,
  group_mappings = NULL,
  create_roc_plot = TRUE,
  create_calibration_plot = TRUE,
  analyse_gate_weights = TRUE,
  analyse_gate_entropy = TRUE,
  verbose = FALSE,
  nonparametric = FALSE
)
}
\arguments{
\item{gnn_results}{List from \code{train_gnn()} (expects $final_results, $performance_summary, $gate_weights).}

\item{prepared_data}{List from \code{prepare_data()} (used to retrieve group mappings if not provided).}

\item{group_mappings}{Optional named mapping from group codes (names) to labels (values).}

\item{create_roc_plot}{Logical; return ROC ggplot (default TRUE).}

\item{create_calibration_plot}{Logical; return calibration ggplot (default TRUE).}

\item{analyse_gate_weights}{Logical; analyse gate weights across groups (default TRUE).}

\item{analyse_gate_entropy}{Logical; analyse gate entropy across groups (default TRUE).}

\item{verbose}{Logical; print progress messages.}

\item{nonparametric}{Logical; if TRUE and k>2, use Kruskal-Wallis + Wilcoxon instead of ANOVA + Tukey.}
}
\value{
A list of ggplots, test results, and summary tables.
}
\description{
Generates ROC/Calibration outputs and subgroup gate analyses.
}
