% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levene.plan.datatable.R
\name{levene.plan.datatable}
\alias{levene.plan.datatable}
\title{Levene/Brown-Forsythe test for full-plan cells}
\usage{
levene.plan.datatable(
  formula,
  data,
  center = c("median", "mean"),
  force_factors = TRUE
)
}
\arguments{
\item{formula}{A model formula \code{y ~ A + B (+ C ...)}.}

\item{data}{A data frame with the variables.}

\item{center}{Character, \code{"median"} (default) for Brown-Forsythe or \code{"mean"} for classical Levene.}

\item{force_factors}{Logical; if TRUE, coerces RHS predictors to factors.}
}
\value{
A one-row data.frame with columns:
\code{Effect}, \code{n.groups}, \code{min.n}, \code{df.num}, \code{df.den}, \code{F}, \code{p}, \code{OK}.
Values \code{F} and \code{p} are formatted to 4 decimals (no scientific notation); \code{OK} is
"OK" if \code{p >= 0.05}, otherwise "NOT OK".
}
\description{
Tests homogeneity of variances across the highest-order interaction (all RHS factors combined),
using Levene's test (Brown-Forsythe with median by default).
}
\details{
Internally relies on \code{car::leveneTest}. If fewer than two groups or any group
has < 2 observations, NA values are returned with a warning.
}
\examples{
\dontrun{
levene.plan.datatable(liking ~ gender + condition + age_cat, data = mimicry)
levene.plan.datatable(liking ~ gender + condition, data = mimicry, center = "mean")
}
}
\seealso{
\code{\link{plan.diagnostics}}
}
