% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformif.R
\name{transformif}
\alias{transformif}
\title{Transformation}
\usage{
transformif(x, cond, a = -abs(min(x)), b = 1, p = 1)
}
\arguments{
\item{x}{vector: values}

\item{cond}{logical: condition if transformation should be applied}

\item{a}{numeric: shift (default: \code{-abs(min(x))})}

\item{b}{numeric: scale (default: \code{1}))}

\item{p}{numeric: power (default: \code{1}))}
}
\value{
A transformed vector
}
\description{
Transforms \code{x} if \code{cond} is \code{TRUE} by \eqn{\log(a+b*x)} if \code{p==0} and \eqn{(a+b*x)^p)}.
Otherwise the transformation can be either applied to each element of \code{x}, or to all elements of \code{x}.
}
\examples{
x <- rnorm(5)
transformif(x, min(x)<0)  # all transformed elements > 0
transformif(x, x<0)       # only negative elements are transformed
}
