% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affix.R
\name{affix}
\alias{affix}
\alias{add_affix}
\alias{add_math}
\alias{lmath}
\alias{add_bracket}
\alias{brkt}
\alias{add_cdata}
\alias{remove_affix}
\alias{remove_quotes}
\alias{remove_cdata}
\alias{math}
\alias{bracket}
\alias{unaffix}
\alias{unquote}
\alias{uncdata}
\alias{cdata}
\title{Quote, Bracket, and Prefix/Suffix String Manipulation}
\usage{
affix(txt, prefix = "", suffix = "")

math(txt)

bracket(txt)

unaffix(txt, prefix = "", suffix = "")

unquote(txt)

uncdata(txt)

cdata(txt)

add_affix(txt, prefix = "", suffix = "")

add_cdata(txt)

add_math(txt)

lmath(txt)

add_bracket(txt)

brkt(txt)

remove_affix(txt, prefix = "", suffix = "")

remove_quotes(txt)

remove_cdata(txt)
}
\arguments{
\item{txt}{\code{character} vector to modify.}

\item{prefix}{\code{character(1)} Prefix to add or remove. Default is \code{""}.}

\item{suffix}{\code{character(1)} Suffix to add or remove. Default is \code{""}.}
}
\value{
A modified \code{character} vector of the same length as \code{txt}.
}
\description{
A set of helper functions for adding or removing specific prefixes and/or suffixes
to character vectors. This is useful for formatting strings in mathematical,
XML, or other structured text contexts.
\itemize{
\item \code{affix()} – Add any prefix and/or suffix to each element of a character vector; alias: \code{add_affix()}.
\item \code{math()} – Add a dollar sign (\code{$}) to both ends of each element (LaTeX-style math); aliases: \code{add_math()}, \code{lmath()}.
\item \code{bracket()} – Wrap each element in parentheses; aliases: \code{add_bracket()}, \code{brkt()}.
\item \code{cdata()} – Wrap each element in \verb{<![CDATA[ ... ]]>} (XML CDATA section); alias: \code{add_cdata()}.
\item \code{unaffix()} – Remove a given prefix and/or suffix from each element; alias: \code{remove_affix()}.
\item \code{unquote()} – Remove surrounding double quotes from each element; alias: \code{remove_quotes()}.
\item \code{uncdata()} – Remove a surrounding CDATA section from each element.; alias: \code{remove_cdata()}.
}
}
\examples{
x <- c("alpha", "beta", "gamma")

# Add a prefix and suffix
affix(x, "[", "]")
#> [1] "[alpha]" "[beta]" "[gamma]"

# Wrap with LaTeX math delimiters
math(x)
#> [1] "$alpha$" "$beta$" "$gamma$"

# Remove quotes
quoted <- c('"a"', '"b"')
unquote(quoted)
#> [1] "a" "b"

# Wrap and unwrap CDATA
cdata_x <- cdata("text")
uncdata(cdata_x)
}
