% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evmissing-package.R
\docType{package}
\name{evmissing-package}
\alias{evmissing}
\alias{evmissing-package}
\title{evmissing: Extreme Value Analyses with Missing Data}
\description{
Performs likelihood-based extreme value inferences with
adjustment for the presence of missing values. A Generalised Extreme Value
(GEV) distribution is fitted to block maxima using maximum likelihood
estimation, with the GEV location and scale parameters reflecting the
numbers of non-missing raw values in each block. A Bayesian version is also
provided. For the purposes of comparison, there are options to make no
adjustment for missing values or to discard any block maximum for which
greater than a percentage of the underlying raw values are missing.

The \code{evmissing} package was created to accompany Simpson, E. S. and
Northrop, P. J. (2025) Accounting for missing data when modelling block
maxima. \doi{10.48550/arXiv.2512.15429}
}
\details{
The main functions are
\itemize{
\item \code{\link{gev_mle}}: maximum likelihood inference for block maxima based on a GEV
distribution, with \code{\link[=evmissing_methods]{S3 methods}} including \code{confint}.
\item \code{\link{gev_bayes}}: Bayesian inference for block maxima based on a GEV
distribution.
}

For objects returned by \code{gev_mle}, inferences about return levels are
performed by \code{\link{gev_return}}, with with \code{\link[=return_level_methods]{S3 methods}}
including \code{confint}.

The function \code{\link{gev_influence}} quantifies the influence that individual
extreme (small or large) block maxima have on the maximum likelihood
estimators of GEV parameters.

The following example datasets are provided.
\itemize{
\item \code{\link{BloomsburyOzoneMaxima}}: Annual maxima ozone levels at Bloomsbury,
London, UK, 1992-2024.
\item \code{\link{PlymouthOzoneMaxima}}: Annual maxima ozone levels at Plymouth, Devon,
UK, 1998-2024.
\item \code{\link{BrestSurgeMaxima}}: Annual maxima surge heights at Brest, France,
1846-2007.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://paulnorthrop.github.io/evmissing/}
  \item \url{https://github.com/paulnorthrop/evmissing}
  \item Report bugs at \url{https://github.com/paulnorthrop/evmissing/issues}
}

}
\author{
\strong{Maintainer}: Paul J. Northrop \email{p.northrop@ucl.ac.uk} [copyright holder]

Authors:
\itemize{
  \item Emma S. Simpson [copyright holder]
}

}
