% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/end_activities.R
\name{end_activities}
\alias{end_activities}
\alias{end_activities.eventlog}
\alias{end_activities.grouped_eventlog}
\alias{end_activities.activitylog}
\alias{end_activities.grouped_activitylog}
\title{End activities}
\usage{
end_activities(
  log,
  level = c("log", "case", "activity", "resource", "resource-activity"),
  sort = TRUE
)

\method{end_activities}{eventlog}(
  log,
  level = c("log", "case", "activity", "resource", "resource-activity"),
  sort = TRUE
)

\method{end_activities}{grouped_eventlog}(
  log,
  level = c("log", "case", "activity", "resource", "resource-activity"),
  sort = TRUE
)

\method{end_activities}{activitylog}(
  log,
  level = c("log", "case", "activity", "resource", "resource-activity"),
  sort = TRUE
)

\method{end_activities}{grouped_activitylog}(
  log,
  level = c("log", "case", "activity", "resource", "resource-activity"),
  sort = TRUE
)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{level}{\code{\link{character}} (default \code{"log"}): Level of granularity for the analysis: \code{"log"} (default),
\code{"case"}, \code{"activity"}, \code{"resource"}, or \code{"resource-activity"}. For more information,
see \code{vignette("metrics", "edeaR")} and 'Details' below.}

\item{sort}{\code{\link{logical}} (default \code{TRUE}): Sort output on count. Only for levels with frequency count output.}
}
\description{
Analyse the end activities in the process.
}
\details{
Argument \code{level} has the following options:
\itemize{
\item At \code{log} level, this metric shows the absolute and relative number of activities that are the last activity
in one or more of the cases.
\item On \code{case} level, this metric provides an overview of the end activity of each case.
\item On \code{activity} level, this metric calculates for each activity the absolute and relative number of cases that
end with this activity type. Similar to the \code{\link{start_activities}} metric, the relative number is calculated
as a portion of the number of cases, being the number of "opportunities" that an activity could be the end activity.
The cumulative sum is added to have an insight in the number of activities that is required to cover a certain part of the total.
\item At \code{resource} level, an overview of which resources execute the last activity per case is provided.
\item On \code{resource-activity} level, this metric shows for each occurring resource-activity combination the absolute
and relative number of times this resource executes this activity as an end activity in a case.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{end_activities(eventlog)}: Computes the end activities for an \code{\link[bupaR]{eventlog}}.

\item \code{end_activities(grouped_eventlog)}: Computes the end activities for a \code{\link[bupaR]{grouped_eventlog}}.

\item \code{end_activities(activitylog)}: Computes the end activities for an \code{\link[bupaR]{activitylog}}.

\item \code{end_activities(grouped_activitylog)}: Computes the end activities for a \code{\link[bupaR]{grouped_activitylog}}.

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
\code{\link{start_activities}}

Other metrics: 
\code{\link{activity_frequency}()},
\code{\link{activity_presence}()},
\code{\link{idle_time}()},
\code{\link{number_of_repetitions}()},
\code{\link{number_of_selfloops}()},
\code{\link{number_of_traces}()},
\code{\link{processing_time}()},
\code{\link{resource_frequency}()},
\code{\link{resource_involvement}()},
\code{\link{resource_specialisation}()},
\code{\link{start_activities}()},
\code{\link{throughput_time}()},
\code{\link{trace_coverage}()},
\code{\link{trace_length}()}
}
\concept{metrics}
\concept{metrics_structuredness}
