% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_gg.R
\name{ggvio}
\alias{ggvio}
\title{Violin plot wrapper for categorical covariates}
\usage{
ggvio(d, var, cats, alpha = 0.1, show = TRUE, nsub = TRUE, ...)
}
\arguments{
\item{d}{\verb{<dfr>} A data frame.}

\item{var}{\verb{<var>} A variable to plot as unquoted name.}

\item{cats}{\verb{<var>} Optional. Categorical variables to plot as a vector of unquoted names.}

\item{alpha}{\verb{<num>} Alpha value for \link[ggplot2:geom_jitter]{ggplot2::geom_jitter}.}

\item{show}{\verb{<lgl>} \code{TRUE} to show data using \link[ggplot2:geom_jitter]{ggplot2::geom_jitter}.}

\item{nsub}{\verb{<lgl>} Show number of observations.}

\item{...}{Additional arguments for \link[ggplot2:geom_violin]{ggplot2::geom_violin}.}
}
\value{
A ggplot object.
}
\description{
Create violin plots for a chosen variable by all discrete covariates in a dataset.
Numeric variables will be dropped, except the chosen variable to plot.
}
\examples{
d = mtcars |> mutate(across(c(am,carb,cyl,gear,vs),factor))
d |> ggvio(mpg)
d |> ggvio(mpg,alpha=0.5)
d |> ggvio(mpg,show=FALSE)
d |> ggvio(mpg,nsub=FALSE)
d |> ggvio(mpg,c(cyl,vs))
}
