% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nem_plot.R
\name{nem_plot,compare-method}
\alias{nem_plot,compare-method}
\title{Visualizing the results of multiple comparisons (single factor)}
\usage{
\S4method{nem_plot}{compare}(object, type = 1, add, ...)
}
\arguments{
\item{object}{A \code{\link{compare-class}} object.}

\item{type}{\code{type = 1}, draws a box plot; \code{type = 2} draws a bar plot.
Default \code{type = 1}.}

\item{add}{Add standard deviation or standard error (only used when drawing a
bar plot).}

\item{...}{Other parameters to be expanded.}
}
\value{
An \code{gg} or \code{ggplot} object.
}
\description{
The \code{\link{nem_plot}} function is generalized to the \code{\link{compare-class}}
and is used to visualize the results of single-factor multiple comparisons.
}
\details{
To facilitate code interpretation, it is recommended to use the pipe symbol
\code{\link{|>}} to connect functions:

\if{html}{\out{<div class="sourceCode">}}\preformatted{nem_plot <- nem |> calc_compare(.group = con_crop, y = pH, method = LSD) |> nem_plot()
}\if{html}{\out{</div>}}
}
\examples{
nem <- read_nem2(tab = nemtab, tax = nemtax, meta = nemmeta)
nem_plot <- nem |> calc_compare(.group = Treatments,
              y = Mesorhabditis,
              method = LSD) |>
            nem_plot()
nem_plot
nem_plot <- nem |> calc_compare(.group = Treatments,
              y = Mesorhabditis,
              method = HSD) |>
            nem_plot(type = 2, add = "mean_se")
nem_plot
}
\seealso{
The \code{nem_plot()} is used to visualize the calculation results and is a
generalized function for multiple classes including \code{\link{beta-class}},
\code{\link{beta2-class}}, \code{\link{compare-class}}, \code{\link{compare2-class}},
\code{\link{ef-class}}, \code{\link{ef2-class}}, \code{\link{funguild-class}},
\code{\link{funguild2-class}}, \code{\link{mf-class}}, \code{\link{mf2-class}},
\code{\link{ter-class}}, \code{\link{ter2-class}}, etc.
}
