% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{run_condition}
\alias{run_condition}
\title{Run a given condition with multiple trials}
\usage{
run_condition(
  condition_setting,
  between_trial_formulas,
  item_formulas,
  n_trials,
  n_items,
  max_reached,
  max_t,
  dt,
  noise_mechanism,
  noise_factory,
  backend,
  trajectories = FALSE
)
}
\arguments{
\item{condition_setting}{A list of named values representing the condition
settings}

\item{between_trial_formulas}{A list of formulas defining the between-trial
parameters}

\item{item_formulas}{A list of formulas defining the item parameters}

\item{n_trials}{The number of trials to simulate}

\item{n_items}{The number of items per trial}

\item{max_reached}{The threshold for evidence accumulation}

\item{max_t}{The maximum time to simulate}

\item{dt}{The step size for each increment}

\item{noise_mechanism}{The noise mechanism to use ("add" or "mult")}

\item{noise_factory}{A function that takes condition_setting and returns a
noise function with signature function(n, dt)}

\item{backend}{The backend implementation to use ("ddm", "ddm-2b", or "lca-gi")}

\item{trajectories}{Whether to return full output including trajectories.}
}
\value{
A list containing the simulation results and condition parameters
}
\description{
This function runs multiple trials for a given condition using the specified
}
\keyword{internal}
