% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsp-package.R
\docType{package}
\name{dsp-package}
\alias{dsp}
\alias{dsp-package}
\title{dsp: Dynamic Shrinkage Process and Change Point Detection}
\description{
Provides efficient Markov chain Monte Carlo (MCMC) algorithms for dynamic shrinkage processes, which extend global-local shrinkage priors to the time series setting by allowing shrinkage to depend on its own past. These priors yield locally adaptive estimates, useful for time series and regression functions with irregular features. The package includes full MCMC implementations for trend filtering using dynamic shrinkage on signal differences, producing locally constant or linear fits with adaptive credible bands. Also included are models with static shrinkage and normal-inverse-Gamma priors for comparison. Additional tools cover dynamic regression with time-varying coefficients and B-spline models with shrinkage on basis differences, allowing for flexible curve-fitting with unequally spaced data. Some support for heteroscedastic errors, outlier detection, and change point estimation. Methods in this package are described in Kowal et al. (2019) \doi{10.1111/rssb.12325}, Wu et al. (2024) \doi{10.1080/07350015.2024.2362269}, Schafer and Matteson (2024) \doi{10.1080/00401706.2024.2407316}, and Cho and Matteson (2024) \doi{10.48550/arXiv.2408.11315}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/schafert/dsp}
  \item Report bugs at \url{https://github.com/schafert/dsp/issues}
}

}
\author{
\strong{Maintainer}: Toryn Schafer \email{toryn27@gmail.com} (\href{https://orcid.org/0000-0001-5594-7697}{ORCID})

Authors:
\itemize{
  \item Daniel R. Kowal \email{daniel.kowal@rice.edu} [copyright holder]
  \item Haoxuan Wu \email{hw399@cornell.edu}
  \item Jason B. Cho \email{bc454@cornell.edu}
  \item David S. Matteson \email{matteson@cornell.edu}
}

}
\keyword{internal}
